/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.ExceptionHandler;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.Indexer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.ItemStore;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.Store;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.ListerWatcher;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache.CacheImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache.ProcessorStore;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache.Reflector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache.SharedProcessor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<T extends HasMetadata, L extends KubernetesResourceList<T>>
implements SharedIndexInformer<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private final long defaultEventHandlerResyncPeriod;
    private final Reflector<T, L> reflector;
    private final Class<T> apiTypeClass;
    private final ProcessorStore<T> processorStore;
    private final CacheImpl<T> indexer = new CacheImpl();
    private final SharedProcessor<T> processor;
    private final Executor informerExecutor;
    private final String description;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile boolean stopped = false;
    private Future<?> resyncFuture;
    private Stream<T> initialState;

    public DefaultSharedIndexInformer(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, long resyncPeriod, Executor informerExecutor) {
        if (resyncPeriod < 0L) {
            throw new IllegalArgumentException("Invalid resync period provided, It should be a non-negative value");
        }
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.apiTypeClass = apiTypeClass;
        this.description = listerWatcher.getApiEndpointPath();
        this.informerExecutor = informerExecutor;
        this.processor = new SharedProcessor(informerExecutor, this.description);
        this.processorStore = new ProcessorStore<T>(this.indexer, this.processor);
        this.reflector = new Reflector<T, L>(listerWatcher, this.processorStore);
    }

    public DefaultSharedIndexInformer<T, L> addEventHandler(ResourceEventHandler<? super T> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
        return this;
    }

    @Override
    public SharedIndexInformer<T> addEventHandlerWithResyncPeriod(ResourceEventHandler<? super T> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to {} because it has stopped already", (Object)this);
            return this;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small for {}. Changing it to minimal allowed value of {}", new Object[]{resyncPeriodMillis, this, 1000L});
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started.get()) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the {} informer has already started. Changing it to {}", new Object[]{resyncPeriodMillis, this.resyncCheckPeriodMillis, this, this.resyncCheckPeriodMillis});
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        this.processor.addProcessorListener(handler, this.determineResyncPeriod(resyncPeriodMillis, this.resyncCheckPeriodMillis), this.indexer::list);
        return this;
    }

    @Override
    public String lastSyncResourceVersion() {
        return this.reflector.getLastSyncResourceVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> start() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot restart a stopped informer");
        }
        DefaultSharedIndexInformer defaultSharedIndexInformer = this;
        synchronized (defaultSharedIndexInformer) {
            if (!this.started.compareAndSet(false, true)) {
                return this.reflector.getStartFuture();
            }
            if (this.initialState != null) {
                this.initialState.forEach(this.indexer::put);
                this.reflector.usingInitialState();
            }
        }
        log.debug("Ready to run resync and reflector for {} with resync {}", (Object)this, (Object)this.resyncCheckPeriodMillis);
        this.scheduleResync(this.processor::shouldResync);
        return this.reflector.start();
    }

    @Override
    public SharedIndexInformer<T> run() {
        Utils.waitUntilReadyOrFail(this.start(), -1L, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public synchronized void stop() {
        this.stopped = true;
        this.reflector.stop();
        this.stopResync();
        this.processor.stop();
    }

    private synchronized void stopResync() {
        if (this.resyncFuture != null) {
            this.resyncFuture.cancel(true);
            this.resyncFuture = null;
        }
    }

    @Override
    public SharedIndexInformer<T> addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.indexer.addIndexers(indexers);
        return this;
    }

    @Override
    public Indexer<T> getIndexer() {
        return this.indexer;
    }

    @Override
    public Store<T> getStore() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check) {
        if (desired == 0L) {
            return desired;
        }
        if (check == 0L) {
            return 0L;
        }
        return Math.max(desired, check);
    }

    @Override
    public boolean isRunning() {
        return !this.stopped && this.started.get() && !this.reflector.isStopped();
    }

    @Override
    public boolean isWatching() {
        return this.reflector.isWatching();
    }

    synchronized void scheduleResync(BooleanSupplier resyncFunc) {
        if (this.resyncCheckPeriodMillis > 0L) {
            this.resyncFuture = Utils.scheduleAtFixedRate(this.informerExecutor, () -> {
                if (log.isDebugEnabled()) {
                    log.debug("Checking for resync at interval for {}", (Object)this);
                }
                if (resyncFunc.getAsBoolean()) {
                    log.debug("Resync running for {}", (Object)this);
                    this.processorStore.resync();
                }
            }, this.resyncCheckPeriodMillis, this.resyncCheckPeriodMillis, TimeUnit.MILLISECONDS);
        } else {
            log.debug("Resync skipped due to 0 full resync period for {}", (Object)this);
        }
    }

    public long getFullResyncPeriod() {
        return this.resyncCheckPeriodMillis;
    }

    Future<?> getResyncFuture() {
        return this.resyncFuture;
    }

    @Override
    public Class<T> getApiTypeClass() {
        return this.apiTypeClass;
    }

    @Override
    public SharedIndexInformer<T> removeIndexer(String name) {
        this.indexer.removeIndexer(name);
        return this;
    }

    @Override
    public synchronized SharedIndexInformer<T> initialState(Stream<T> items) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when initial state is added");
        }
        this.initialState = items;
        return this;
    }

    @Override
    public synchronized SharedIndexInformer<T> itemStore(ItemStore<T> itemStore) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when setting item store");
        }
        this.indexer.setItemStore(itemStore);
        return this;
    }

    public String toString() {
        return this.description;
    }

    public CompletableFuture<Void> stopped() {
        return this.reflector.getStopFuture();
    }

    public synchronized DefaultSharedIndexInformer<T, L> exceptionHandler(ExceptionHandler handler) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when handler is set");
        }
        this.reflector.setExceptionHandler(handler);
        return this;
    }
}

