/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecFluentImpl;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerSpecFluent<A> {
    private HorizontalPodAutoscalerBehaviorBuilder behavior;
    private Integer maxReplicas;
    private ArrayList<MetricSpecBuilder> metrics = new ArrayList();
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance) {
        this.withBehavior(instance.getBehavior());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMetrics(instance.getMetrics());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public HorizontalPodAutoscalerBehavior getBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    @Override
    public HorizontalPodAutoscalerBehavior buildBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    @Override
    public A withBehavior(HorizontalPodAutoscalerBehavior behavior) {
        this._visitables.get("behavior").remove(this.behavior);
        if (behavior != null) {
            this.behavior = new HorizontalPodAutoscalerBehaviorBuilder(behavior);
            this._visitables.get("behavior").add(this.behavior);
        } else {
            this.behavior = null;
            this._visitables.get("behavior").remove(this.behavior);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBehavior() {
        return this.behavior != null;
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehavior() {
        return new BehaviorNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehaviorLike(HorizontalPodAutoscalerBehavior item) {
        return new BehaviorNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editBehavior() {
        return this.withNewBehaviorLike(this.getBehavior());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehavior() {
        return this.withNewBehaviorLike(this.getBehavior() != null ? this.getBehavior() : new HorizontalPodAutoscalerBehaviorBuilder().build());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehaviorLike(HorizontalPodAutoscalerBehavior item) {
        return this.withNewBehaviorLike(this.getBehavior() != null ? this.getBehavior() : item);
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A addToMetrics(Integer index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        this._visitables.get("metrics").add(index >= 0 ? index.intValue() : this._visitables.get("metrics").size(), builder);
        this.metrics.add(index >= 0 ? index.intValue() : this.metrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetrics(Integer index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("metrics").size()) {
            this._visitables.get("metrics").add(builder);
        } else {
            this._visitables.get("metrics").set(index, builder);
        }
        if (index < 0 || index >= this.metrics.size()) {
            this.metrics.add(builder);
        } else {
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetrics(Collection<MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(MetricSpec ... items) {
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetrics(Collection<MetricSpec> items) {
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetrics(Predicate<MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            MetricSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MetricSpec> getMetrics() {
        return this.metrics != null ? HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public List<MetricSpec> buildMetrics() {
        return this.metrics != null ? HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public MetricSpec buildMetric(Integer index) {
        return this.metrics.get(index).build();
    }

    @Override
    public MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    @Override
    public MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    @Override
    public MetricSpec buildMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetrics(List<MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").removeAll(this.metrics);
        }
        if (metrics != null) {
            this.metrics = new ArrayList();
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    @Override
    public A withMetrics(MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
        }
        if (metrics != null) {
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(MetricSpec item) {
        return new MetricsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(Integer index, MetricSpec item) {
        return new MetricsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(Integer index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.test(this.metrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) {
            return false;
        }
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        if (this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.behavior != null) {
            sb.append("behavior:");
            sb.append(this.behavior + ",");
        }
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.metrics != null && !this.metrics.isEmpty()) {
            sb.append("metrics:");
            sb.append(this.metrics + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ScaleTargetRefNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }

    class MetricsNestedImpl<N>
    extends MetricSpecFluentImpl<HorizontalPodAutoscalerSpecFluent.MetricsNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,
    Nested<N> {
        MetricSpecBuilder builder;
        Integer index;

        MetricsNestedImpl(Integer index, MetricSpec item) {
            this.index = index;
            this.builder = new MetricSpecBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(this.index, this.builder.build());
        }

        @Override
        public N endMetric() {
            return this.and();
        }
    }

    class BehaviorNestedImpl<N>
    extends HorizontalPodAutoscalerBehaviorFluentImpl<HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>,
    Nested<N> {
        HorizontalPodAutoscalerBehaviorBuilder builder;

        BehaviorNestedImpl(HorizontalPodAutoscalerBehavior item) {
            this.builder = new HorizontalPodAutoscalerBehaviorBuilder(this, item);
        }

        BehaviorNestedImpl() {
            this.builder = new HorizontalPodAutoscalerBehaviorBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withBehavior(this.builder.build());
        }

        @Override
        public N endBehavior() {
            return this.and();
        }
    }
}

