/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluentImpl;

public class ResourceRuleBuilder
extends ResourceRuleFluentImpl<ResourceRuleBuilder>
implements VisitableBuilder<ResourceRule, ResourceRuleBuilder> {
    ResourceRuleFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRuleBuilder() {
        this(false);
    }

    public ResourceRuleBuilder(Boolean validationEnabled) {
        this(new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance) {
        this(fluent, instance, false);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRuleBuilder(ResourceRule instance) {
        this(instance, (Boolean)false);
    }

    public ResourceRuleBuilder(ResourceRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceRule build() {
        ResourceRule buildable = new ResourceRule(this.fluent.getApiGroups(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

