/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.Indexer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.ReflectUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public class Cache<T>
implements Indexer<T> {
    private Function<T, String> keyFunc;
    public static final String NAMESPACE_INDEX = "namespace";
    private final Map<String, Function<T, List<String>>> indexers = new HashMap<String, Function<T, List<String>>>();
    private volatile ConcurrentHashMap<String, T> items = new ConcurrentHashMap();
    private final Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();
    private BooleanSupplier isRunning = () -> false;

    public Cache() {
        this(NAMESPACE_INDEX, Cache::metaNamespaceIndexFunc, Cache::metaNamespaceKeyFunc);
    }

    public Cache(String indexName, Function<T, List<String>> indexFunc, Function<T, String> keyFunc) {
        this.indexers.put(indexName, indexFunc);
        this.keyFunc = keyFunc;
        this.indices.put(indexName, new HashMap());
    }

    public void setIsRunning(BooleanSupplier isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public synchronized Map<String, Function<T, List<String>>> getIndexers() {
        return Collections.unmodifiableMap(this.indexers);
    }

    @Override
    public synchronized void addIndexers(Map<String, Function<T, List<String>>> indexersNew) {
        if (this.isRunning.getAsBoolean()) {
            throw new IllegalStateException("Cannot add indexers to a running informer.");
        }
        if (!this.items.isEmpty()) {
            throw new IllegalStateException("Cannot add indexers to a Cache which is not empty");
        }
        HashSet<String> intersection = new HashSet<String>(this.indexers.keySet());
        intersection.retainAll(indexersNew.keySet());
        if (!intersection.isEmpty()) {
            throw new IllegalArgumentException("Indexer conflict: " + intersection);
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : indexersNew.entrySet()) {
            this.addIndexFunc(indexEntry.getKey(), indexEntry.getValue());
        }
    }

    public synchronized T put(T obj) {
        if (obj == null) {
            return null;
        }
        String key = this.getKey(obj);
        T oldObj = this.items.put(key, obj);
        this.updateIndices(oldObj, obj, key);
        return oldObj;
    }

    public synchronized T remove(T obj) {
        String key = this.getKey(obj);
        T old = this.items.remove(key);
        if (old != null) {
            this.deleteFromIndices(old, key);
        }
        return old;
    }

    public synchronized Map<String, T> replace(List<T> list) {
        ConcurrentHashMap<String, T> newItems = new ConcurrentHashMap<String, T>();
        for (T item : list) {
            String key = this.getKey(item);
            newItems.put(key, item);
        }
        HashMap<String, T> result = new HashMap<String, T>(this.items);
        this.items = newItems;
        this.indices.values().stream().forEach(Map::clear);
        for (Map.Entry<String, T> itemEntry : this.items.entrySet()) {
            this.updateIndices(null, itemEntry.getValue(), itemEntry.getKey());
        }
        return result;
    }

    @Override
    public List<String> listKeys() {
        return new ArrayList<String>(this.items.keySet());
    }

    @Override
    public T get(T obj) {
        String key = this.getKey(obj);
        return this.getByKey(key);
    }

    public String getKey(T obj) {
        String result = this.keyFunc.apply(obj);
        return result == null ? "" : result;
    }

    @Override
    public List<T> list() {
        return new ArrayList<T>(this.items.values());
    }

    @Override
    public T getByKey(String key) {
        return this.items.get(key);
    }

    @Override
    public synchronized List<T> index(String indexName, T obj) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Function<T, List<String>> indexFunc = this.indexers.get(indexName);
        List<String> indexKeys = indexFunc.apply(obj);
        Map<String, Set<String>> index = this.indices.get(indexName);
        if (index.isEmpty()) {
            return new ArrayList();
        }
        HashSet<String> returnKeySet = new HashSet<String>();
        for (String indexKey : indexKeys) {
            Set<String> set = index.get(indexKey);
            if (set.isEmpty()) continue;
            returnKeySet.addAll(set);
        }
        ArrayList<T> items = new ArrayList<T>(returnKeySet.size());
        for (String absoluteKey : returnKeySet) {
            items.add(this.items.get(absoluteKey));
        }
        return items;
    }

    @Override
    public synchronized List<String> indexKeys(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        ArrayList<String> keys = new ArrayList<String>(set.size());
        for (String key : set) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public synchronized List<T> byIndex(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        if (set == null) {
            return Arrays.asList(new Object[0]);
        }
        ArrayList<T> items = new ArrayList<T>(set.size());
        for (String key : set) {
            items.add(this.items.get(key));
        }
        return items;
    }

    void updateIndices(T oldObj, T newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(newObj);
            if (indexValues == null || indexValues.isEmpty()) continue;
            Map<String, Set<String>> index = this.indices.get(indexName);
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(T oldObj, String key) {
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (indexValues == null || indexValues.isEmpty() || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public synchronized void addIndexFunc(String indexName, Function<T, List<String>> indexFunc) {
        this.indices.put(indexName, new HashMap());
        this.indexers.put(indexName, indexFunc);
    }

    public static String metaNamespaceKeyFunc(Object obj) {
        try {
            ObjectMeta metadata;
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ObjectMeta) {
                metadata = (ObjectMeta)obj;
            } else {
                metadata = ReflectUtils.objectMetadata(obj);
                if (metadata == null) {
                    throw new RuntimeException("Object is bad :" + obj);
                }
            }
            return Cache.namespaceKeyFunc(metadata.getNamespace(), metadata.getName());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String namespaceKeyFunc(String objectNamespace, String objectName) {
        if (Utils.isNullOrEmpty(objectNamespace)) {
            return objectName;
        }
        return objectNamespace + "/" + objectName;
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        try {
            ObjectMeta metadata = ReflectUtils.objectMetadata(obj);
            return metadata == null ? Collections.emptyList() : Collections.singletonList(metadata.getNamespace());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

