/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.EditableRunConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigFluentImpl;

public class RunConfigBuilder
extends RunConfigFluentImpl<RunConfigBuilder>
implements VisitableBuilder<RunConfig, RunConfigBuilder> {
    RunConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RunConfigBuilder() {
        this(false);
    }

    public RunConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public RunConfigBuilder(RunConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RunConfigBuilder(RunConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public RunConfigBuilder(RunConfigFluent<?> fluent, RunConfig instance) {
        this(fluent, instance, false);
    }

    public RunConfigBuilder(RunConfigFluent<?> fluent, RunConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withImage(instance.getImage());
        fluent.withImagePullPolicy(instance.getImagePullPolicy());
        fluent.withCommand(instance.getCommand());
        fluent.withArgs(instance.getArgs());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withLabels(instance.getLabels());
        fluent.withEnv(instance.getEnv());
        fluent.withLimits(instance.getLimits());
        fluent.withRequests(instance.getRequests());
        fluent.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public RunConfigBuilder(RunConfig instance) {
        this(instance, (Boolean)false);
    }

    public RunConfigBuilder(RunConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withCommand(instance.getCommand());
        this.withArgs(instance.getArgs());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withLabels(instance.getLabels());
        this.withEnv(instance.getEnv());
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableRunConfig build() {
        EditableRunConfig buildable = new EditableRunConfig(this.fluent.getName(), this.fluent.getImage(), this.fluent.getImagePullPolicy(), this.fluent.getCommand(), this.fluent.getArgs(), this.fluent.getRestartPolicy(), this.fluent.getServiceAccount(), this.fluent.getLabels(), this.fluent.getEnv(), this.fluent.getLimits(), this.fluent.getRequests(), this.fluent.getPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunConfigBuilder that = (RunConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

