/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.io.InputStream;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.BaseKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ClientContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.RequestConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.WithRequestCallable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.FunctionCallable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;

public class DefaultKubernetesClient
extends BaseKubernetesClient<NamespacedKubernetesClient>
implements NamespacedKubernetesClient {
    public DefaultKubernetesClient() {
    }

    public DefaultKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    public DefaultKubernetesClient(Config config) {
        super(config);
    }

    @Deprecated
    public DefaultKubernetesClient(OkHttpClient httpClient, Config config) {
        super(new OkHttpClientImpl(httpClient), config);
    }

    public DefaultKubernetesClient(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public DefaultKubernetesClient(ClientContext clientContext) {
        super(clientContext);
    }

    public static DefaultKubernetesClient fromConfig(String config) {
        return new DefaultKubernetesClient(Serialization.unmarshal(config, Config.class));
    }

    public static DefaultKubernetesClient fromConfig(InputStream is) {
        return new DefaultKubernetesClient(Serialization.unmarshal(is, Config.class));
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(name)).build();
        return new DefaultKubernetesClient(this.newState(updated));
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedKubernetesClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedKubernetesClient>(this, requestConfig);
    }
}

