/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSourceFluent;

public class ContainerResourceMetricSourceFluentImpl<A extends ContainerResourceMetricSourceFluent<A>>
extends BaseFluent<A>
implements ContainerResourceMetricSourceFluent<A> {
    private String container;
    private String name;
    private Integer targetAverageUtilization;
    private Quantity targetAverageValue;
    private Map<String, Object> additionalProperties;

    public ContainerResourceMetricSourceFluentImpl() {
    }

    public ContainerResourceMetricSourceFluentImpl(ContainerResourceMetricSource instance) {
        this.withContainer(instance.getContainer());
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    @Deprecated
    public A withNewContainer(String arg0) {
        return this.withContainer(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    @Override
    public A withTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageUtilization() {
        return this.targetAverageUtilization != null;
    }

    @Override
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResourceMetricSourceFluentImpl that = (ContainerResourceMetricSourceFluentImpl)o;
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.targetAverageUtilization != null ? !this.targetAverageUtilization.equals(that.targetAverageUtilization) : that.targetAverageUtilization != null) {
            return false;
        }
        if (this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.name, this.targetAverageUtilization, this.targetAverageValue, this.additionalProperties, super.hashCode());
    }
}

