/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSetCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluentImpl;

public class StatefulSetConditionBuilder
extends StatefulSetConditionFluentImpl<StatefulSetConditionBuilder>
implements VisitableBuilder<StatefulSetCondition, StatefulSetConditionBuilder> {
    StatefulSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetConditionBuilder() {
        this(false);
    }

    public StatefulSetConditionBuilder(Boolean validationEnabled) {
        this(new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance) {
        this(fluent, instance, false);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSetCondition build() {
        StatefulSetCondition buildable = new StatefulSetCondition(this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetConditionBuilder that = (StatefulSetConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

