/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigFluent;

public class WebhookClientConfigFluentImpl<A extends WebhookClientConfigFluent<A>>
extends BaseFluent<A>
implements WebhookClientConfigFluent<A> {
    private String caBundle;
    private ServiceReferenceBuilder service;
    private String url;
    private Map<String, Object> additionalProperties;

    public WebhookClientConfigFluentImpl() {
    }

    public WebhookClientConfigFluentImpl(WebhookClientConfig instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withService(instance.getService());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getCaBundle() {
        return this.caBundle;
    }

    @Override
    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    @Override
    @Deprecated
    public A withNewCaBundle(String arg0) {
        return this.withCaBundle(new String(arg0));
    }

    @Override
    @Deprecated
    public ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ServiceReference service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public A withNewService(String name, String namespace, String path, Integer port) {
        return this.withService(new ServiceReference(name, namespace, path, port));
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ServiceReferenceBuilder().build());
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    @Deprecated
    public A withNewUrl(String arg0) {
        return this.withUrl(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookClientConfigFluentImpl that = (WebhookClientConfigFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.caBundle, this.service, this.url, this.additionalProperties, super.hashCode());
    }

    public class ServiceNestedImpl<N>
    extends ServiceReferenceFluentImpl<WebhookClientConfigFluent.ServiceNested<N>>
    implements WebhookClientConfigFluent.ServiceNested<N>,
    Nested<N> {
        ServiceReferenceBuilder builder;

        ServiceNestedImpl(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebhookClientConfigFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

