/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.QuantityBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.QuantityFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;

public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>>
extends BaseFluent<A>
implements ResourceFieldSelectorFluent<A> {
    private String containerName;
    private QuantityBuilder divisor;
    private String resource;
    private Map<String, Object> additionalProperties;

    public ResourceFieldSelectorFluentImpl() {
    }

    public ResourceFieldSelectorFluentImpl(ResourceFieldSelector instance) {
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    @Deprecated
    public A withNewContainerName(String arg0) {
        return this.withContainerName(new String(arg0));
    }

    @Override
    @Deprecated
    public Quantity getDivisor() {
        return this.divisor != null ? this.divisor.build() : null;
    }

    @Override
    public Quantity buildDivisor() {
        return this.divisor != null ? this.divisor.build() : null;
    }

    @Override
    public A withDivisor(Quantity divisor) {
        this._visitables.get("divisor").remove(this.divisor);
        if (divisor != null) {
            this.divisor = new QuantityBuilder(divisor);
            this._visitables.get("divisor").add(this.divisor);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDivisor() {
        return this.divisor != null;
    }

    @Override
    public A withNewDivisor(String amount, String format) {
        return this.withDivisor(new Quantity(amount, format));
    }

    @Override
    public A withNewDivisor(String amount) {
        return this.withDivisor(new Quantity(amount));
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor() {
        return new DivisorNestedImpl();
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item) {
        return new DivisorNestedImpl(item);
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor() {
        return this.withNewDivisorLike(this.getDivisor());
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisor() {
        return this.withNewDivisorLike(this.getDivisor() != null ? this.getDivisor() : new QuantityBuilder().build());
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisorLike(Quantity item) {
        return this.withNewDivisorLike(this.getDivisor() != null ? this.getDivisor() : item);
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    @Deprecated
    public A withNewResource(String arg0) {
        return this.withResource(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl)o;
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.divisor != null ? !this.divisor.equals(that.divisor) : that.divisor != null) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource, this.additionalProperties, super.hashCode());
    }

    public class DivisorNestedImpl<N>
    extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>>
    implements ResourceFieldSelectorFluent.DivisorNested<N>,
    Nested<N> {
        QuantityBuilder builder;

        DivisorNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        DivisorNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceFieldSelectorFluentImpl.this.withDivisor(this.builder.build());
        }

        @Override
        public N endDivisor() {
            return this.and();
        }
    }
}

