/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodStatusFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodStatusFluentImpl;

public class PodStatusBuilder
extends PodStatusFluentImpl<PodStatusBuilder>
implements VisitableBuilder<PodStatus, PodStatusBuilder> {
    PodStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PodStatusBuilder() {
        this(false);
    }

    public PodStatusBuilder(Boolean validationEnabled) {
        this(new PodStatus(), validationEnabled);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodStatus(), validationEnabled);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance) {
        this(fluent, instance, false);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withContainerStatuses(instance.getContainerStatuses());
        fluent.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
        fluent.withHostIP(instance.getHostIP());
        fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
        fluent.withMessage(instance.getMessage());
        fluent.withNominatedNodeName(instance.getNominatedNodeName());
        fluent.withPhase(instance.getPhase());
        fluent.withPodIP(instance.getPodIP());
        fluent.withPodIPs(instance.getPodIPs());
        fluent.withQosClass(instance.getQosClass());
        fluent.withReason(instance.getReason());
        fluent.withStartTime(instance.getStartTime());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PodStatusBuilder(PodStatus instance) {
        this(instance, (Boolean)false);
    }

    public PodStatusBuilder(PodStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withNominatedNodeName(instance.getNominatedNodeName());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withPodIPs(instance.getPodIPs());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodStatus build() {
        PodStatus buildable = new PodStatus(this.fluent.getConditions(), this.fluent.getContainerStatuses(), this.fluent.getEphemeralContainerStatuses(), this.fluent.getHostIP(), this.fluent.getInitContainerStatuses(), this.fluent.getMessage(), this.fluent.getNominatedNodeName(), this.fluent.getPhase(), this.fluent.getPodIP(), this.fluent.getPodIPs(), this.fluent.getQosClass(), this.fluent.getReason(), this.fluent.getStartTime());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusBuilder that = (PodStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

