/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOption;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluentImpl;

public class PodDNSConfigFluentImpl<A extends PodDNSConfigFluent<A>>
extends BaseFluent<A>
implements PodDNSConfigFluent<A> {
    private List<String> nameservers = new ArrayList<String>();
    private List<PodDNSConfigOptionBuilder> options = new ArrayList<PodDNSConfigOptionBuilder>();
    private List<String> searches = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PodDNSConfigFluentImpl() {
    }

    public PodDNSConfigFluentImpl(PodDNSConfig instance) {
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToNameservers(Integer index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameservers(Integer index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameservers(String ... items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameservers() {
        return this.nameservers;
    }

    @Override
    public String getNameserver(Integer index) {
        return this.nameservers.get(index);
    }

    @Override
    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    @Override
    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    @Override
    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    @Override
    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    @Override
    public A addNewNameserver(String arg0) {
        return this.addToNameservers(new String(arg0));
    }

    @Override
    public A addToOptions(Integer index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        this._visitables.get("options").add(index >= 0 ? index.intValue() : this._visitables.get("options").size(), builder);
        this.options.add(index >= 0 ? index.intValue() : this.options.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOptions(Integer index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this._visitables.get("options").size()) {
            this._visitables.get("options").add(builder);
        } else {
            this._visitables.get("options").set(index, builder);
        }
        if (index < 0 || index >= this.options.size()) {
            this.options.add(builder);
        } else {
            this.options.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(PodDNSConfigOption ... items) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOptions(Collection<PodDNSConfigOption> items) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(PodDNSConfigOption ... items) {
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOptions(Collection<PodDNSConfigOption> items) {
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOptions(Predicate<PodDNSConfigOptionBuilder> predicate) {
        if (this.options == null) {
            return (A)this;
        }
        Iterator<PodDNSConfigOptionBuilder> each = this.options.iterator();
        Object visitables = this._visitables.get("options");
        while (each.hasNext()) {
            PodDNSConfigOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodDNSConfigOption> getOptions() {
        return PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public List<PodDNSConfigOption> buildOptions() {
        return PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public PodDNSConfigOption buildOption(Integer index) {
        return this.options.get(index).build();
    }

    @Override
    public PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    @Override
    public PodDNSConfigOption buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    @Override
    public PodDNSConfigOption buildMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOptions(List<PodDNSConfigOption> options) {
        if (this.options != null) {
            this._visitables.get("options").removeAll(this.options);
        }
        if (options != null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)this;
    }

    @Override
    public A withOptions(PodDNSConfigOption ... options) {
        if (this.options != null) {
            this.options.clear();
        }
        if (options != null) {
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    @Override
    public A addNewOption(String name, String value) {
        return this.addToOptions(new PodDNSConfigOption(name, value));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> addNewOption() {
        return new OptionsNestedImpl();
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(PodDNSConfigOption item) {
        return new OptionsNestedImpl(-1, item);
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(Integer index, PodDNSConfigOption item) {
        return new OptionsNestedImpl(index, item);
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editOption(Integer index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.test(this.options.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public A addToSearches(Integer index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSearches(Integer index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSearches(String ... items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSearches(Collection<String> items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSearches() {
        return this.searches;
    }

    @Override
    public String getSearch(Integer index) {
        return this.searches.get(index);
    }

    @Override
    public String getFirstSearch() {
        return this.searches.get(0);
    }

    @Override
    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    @Override
    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSearches(List<String> searches) {
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = null;
        }
        return (A)this;
    }

    @Override
    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    @Override
    public A addNewSearch(String arg0) {
        return this.addToSearches(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodDNSConfigFluentImpl that = (PodDNSConfigFluentImpl)o;
        if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.searches != null ? !this.searches.equals(that.searches) : that.searches != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches, this.additionalProperties, super.hashCode());
    }

    public class OptionsNestedImpl<N>
    extends PodDNSConfigOptionFluentImpl<PodDNSConfigFluent.OptionsNested<N>>
    implements PodDNSConfigFluent.OptionsNested<N>,
    Nested<N> {
        PodDNSConfigOptionBuilder builder;
        Integer index;

        OptionsNestedImpl(Integer index, PodDNSConfigOption item) {
            this.index = index;
            this.builder = new PodDNSConfigOptionBuilder(this, item);
        }

        OptionsNestedImpl() {
            this.index = -1;
            this.builder = new PodDNSConfigOptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodDNSConfigFluentImpl.this.setToOptions(this.index, this.builder.build());
        }

        @Override
        public N endOption() {
            return this.and();
        }
    }
}

