/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodConditionFluentImpl;

public class PodConditionBuilder
extends PodConditionFluentImpl<PodConditionBuilder>
implements VisitableBuilder<PodCondition, PodConditionBuilder> {
    PodConditionFluent<?> fluent;
    Boolean validationEnabled;

    public PodConditionBuilder() {
        this(false);
    }

    public PodConditionBuilder(Boolean validationEnabled) {
        this(new PodCondition(), validationEnabled);
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodCondition(), validationEnabled);
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent, PodCondition instance) {
        this(fluent, instance, false);
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent, PodCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastProbeTime(instance.getLastProbeTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PodConditionBuilder(PodCondition instance) {
        this(instance, (Boolean)false);
    }

    public PodConditionBuilder(PodCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodCondition build() {
        PodCondition buildable = new PodCondition(this.fluent.getLastProbeTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodConditionBuilder that = (PodConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

