/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeader;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeaderFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl;

public class HTTPHeaderBuilder
extends HTTPHeaderFluentImpl<HTTPHeaderBuilder>
implements VisitableBuilder<HTTPHeader, HTTPHeaderBuilder> {
    HTTPHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPHeaderBuilder() {
        this(false);
    }

    public HTTPHeaderBuilder(Boolean validationEnabled) {
        this(new HTTPHeader(), validationEnabled);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPHeader(), validationEnabled);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance) {
        this(fluent, instance, false);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HTTPHeaderBuilder(HTTPHeader instance) {
        this(instance, (Boolean)false);
    }

    public HTTPHeaderBuilder(HTTPHeader instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HTTPHeader build() {
        HTTPHeader buildable = new HTTPHeader(this.fluent.getName(), this.fluent.getValue());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPHeaderBuilder that = (HTTPHeaderBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

