/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPGetAction;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl;

public class HTTPGetActionBuilder
extends HTTPGetActionFluentImpl<HTTPGetActionBuilder>
implements VisitableBuilder<HTTPGetAction, HTTPGetActionBuilder> {
    HTTPGetActionFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPGetActionBuilder() {
        this(false);
    }

    public HTTPGetActionBuilder(Boolean validationEnabled) {
        this(new HTTPGetAction(), validationEnabled);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPGetAction(), validationEnabled);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance) {
        this(fluent, instance, false);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttpHeaders(instance.getHttpHeaders());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withScheme(instance.getScheme());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HTTPGetActionBuilder(HTTPGetAction instance) {
        this(instance, (Boolean)false);
    }

    public HTTPGetActionBuilder(HTTPGetAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HTTPGetAction build() {
        HTTPGetAction buildable = new HTTPGetAction(this.fluent.getHost(), this.fluent.getHttpHeaders(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getScheme());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionBuilder that = (HTTPGetActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

