/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerState;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateRunning;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateRunningFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentImpl;

public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>>
extends BaseFluent<A>
implements ContainerStateFluent<A> {
    private ContainerStateRunningBuilder running;
    private ContainerStateTerminatedBuilder terminated;
    private ContainerStateWaitingBuilder waiting;
    private Map<String, Object> additionalProperties;

    public ContainerStateFluentImpl() {
    }

    public ContainerStateFluentImpl(ContainerState instance) {
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ContainerStateRunning getRunning() {
        return this.running != null ? this.running.build() : null;
    }

    @Override
    public ContainerStateRunning buildRunning() {
        return this.running != null ? this.running.build() : null;
    }

    @Override
    public A withRunning(ContainerStateRunning running) {
        this._visitables.get("running").remove(this.running);
        if (running != null) {
            this.running = new ContainerStateRunningBuilder(running);
            this._visitables.get("running").add(this.running);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunning() {
        return this.running != null;
    }

    @Override
    public A withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    @Override
    public ContainerStateFluent.RunningNested<A> withNewRunning() {
        return new RunningNestedImpl();
    }

    @Override
    public ContainerStateFluent.RunningNested<A> withNewRunningLike(ContainerStateRunning item) {
        return new RunningNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.RunningNested<A> editRunning() {
        return this.withNewRunningLike(this.getRunning());
    }

    @Override
    public ContainerStateFluent.RunningNested<A> editOrNewRunning() {
        return this.withNewRunningLike(this.getRunning() != null ? this.getRunning() : new ContainerStateRunningBuilder().build());
    }

    @Override
    public ContainerStateFluent.RunningNested<A> editOrNewRunningLike(ContainerStateRunning item) {
        return this.withNewRunningLike(this.getRunning() != null ? this.getRunning() : item);
    }

    @Override
    @Deprecated
    public ContainerStateTerminated getTerminated() {
        return this.terminated != null ? this.terminated.build() : null;
    }

    @Override
    public ContainerStateTerminated buildTerminated() {
        return this.terminated != null ? this.terminated.build() : null;
    }

    @Override
    public A withTerminated(ContainerStateTerminated terminated) {
        this._visitables.get("terminated").remove(this.terminated);
        if (terminated != null) {
            this.terminated = new ContainerStateTerminatedBuilder(terminated);
            this._visitables.get("terminated").add(this.terminated);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTerminated() {
        return this.terminated != null;
    }

    @Override
    public ContainerStateFluent.TerminatedNested<A> withNewTerminated() {
        return new TerminatedNestedImpl();
    }

    @Override
    public ContainerStateFluent.TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item) {
        return new TerminatedNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.TerminatedNested<A> editTerminated() {
        return this.withNewTerminatedLike(this.getTerminated());
    }

    @Override
    public ContainerStateFluent.TerminatedNested<A> editOrNewTerminated() {
        return this.withNewTerminatedLike(this.getTerminated() != null ? this.getTerminated() : new ContainerStateTerminatedBuilder().build());
    }

    @Override
    public ContainerStateFluent.TerminatedNested<A> editOrNewTerminatedLike(ContainerStateTerminated item) {
        return this.withNewTerminatedLike(this.getTerminated() != null ? this.getTerminated() : item);
    }

    @Override
    @Deprecated
    public ContainerStateWaiting getWaiting() {
        return this.waiting != null ? this.waiting.build() : null;
    }

    @Override
    public ContainerStateWaiting buildWaiting() {
        return this.waiting != null ? this.waiting.build() : null;
    }

    @Override
    public A withWaiting(ContainerStateWaiting waiting) {
        this._visitables.get("waiting").remove(this.waiting);
        if (waiting != null) {
            this.waiting = new ContainerStateWaitingBuilder(waiting);
            this._visitables.get("waiting").add(this.waiting);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWaiting() {
        return this.waiting != null;
    }

    @Override
    public A withNewWaiting(String message, String reason) {
        return this.withWaiting(new ContainerStateWaiting(message, reason));
    }

    @Override
    public ContainerStateFluent.WaitingNested<A> withNewWaiting() {
        return new WaitingNestedImpl();
    }

    @Override
    public ContainerStateFluent.WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item) {
        return new WaitingNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.WaitingNested<A> editWaiting() {
        return this.withNewWaitingLike(this.getWaiting());
    }

    @Override
    public ContainerStateFluent.WaitingNested<A> editOrNewWaiting() {
        return this.withNewWaitingLike(this.getWaiting() != null ? this.getWaiting() : new ContainerStateWaitingBuilder().build());
    }

    @Override
    public ContainerStateFluent.WaitingNested<A> editOrNewWaitingLike(ContainerStateWaiting item) {
        return this.withNewWaitingLike(this.getWaiting() != null ? this.getWaiting() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStateFluentImpl that = (ContainerStateFluentImpl)o;
        if (this.running != null ? !this.running.equals(that.running) : that.running != null) {
            return false;
        }
        if (this.terminated != null ? !this.terminated.equals(that.terminated) : that.terminated != null) {
            return false;
        }
        if (this.waiting != null ? !this.waiting.equals(that.waiting) : that.waiting != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.running, this.terminated, this.waiting, this.additionalProperties, super.hashCode());
    }

    public class WaitingNestedImpl<N>
    extends ContainerStateWaitingFluentImpl<ContainerStateFluent.WaitingNested<N>>
    implements ContainerStateFluent.WaitingNested<N>,
    Nested<N> {
        ContainerStateWaitingBuilder builder;

        WaitingNestedImpl(ContainerStateWaiting item) {
            this.builder = new ContainerStateWaitingBuilder(this, item);
        }

        WaitingNestedImpl() {
            this.builder = new ContainerStateWaitingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withWaiting(this.builder.build());
        }

        @Override
        public N endWaiting() {
            return this.and();
        }
    }

    public class TerminatedNestedImpl<N>
    extends ContainerStateTerminatedFluentImpl<ContainerStateFluent.TerminatedNested<N>>
    implements ContainerStateFluent.TerminatedNested<N>,
    Nested<N> {
        ContainerStateTerminatedBuilder builder;

        TerminatedNestedImpl(ContainerStateTerminated item) {
            this.builder = new ContainerStateTerminatedBuilder(this, item);
        }

        TerminatedNestedImpl() {
            this.builder = new ContainerStateTerminatedBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withTerminated(this.builder.build());
        }

        @Override
        public N endTerminated() {
            return this.and();
        }
    }

    public class RunningNestedImpl<N>
    extends ContainerStateRunningFluentImpl<ContainerStateFluent.RunningNested<N>>
    implements ContainerStateFluent.RunningNested<N>,
    Nested<N> {
        ContainerStateRunningBuilder builder;

        RunningNestedImpl(ContainerStateRunning item) {
            this.builder = new ContainerStateRunningBuilder(this, item);
        }

        RunningNestedImpl() {
            this.builder = new ContainerStateRunningBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withRunning(this.builder.build());
        }

        @Override
        public N endRunning() {
            return this.and();
        }
    }
}

