/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerImage;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerImageFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerImageFluentImpl;

public class ContainerImageBuilder
extends ContainerImageFluentImpl<ContainerImageBuilder>
implements VisitableBuilder<ContainerImage, ContainerImageBuilder> {
    ContainerImageFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerImageBuilder() {
        this(false);
    }

    public ContainerImageBuilder(Boolean validationEnabled) {
        this(new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance) {
        this(fluent, instance, false);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNames(instance.getNames());
        fluent.withSizeBytes(instance.getSizeBytes());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerImageBuilder(ContainerImage instance) {
        this(instance, (Boolean)false);
    }

    public ContainerImageBuilder(ContainerImage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerImage build() {
        ContainerImage buildable = new ContainerImage(this.fluent.getNames(), this.fluent.getSizeBytes());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerImageBuilder that = (ContainerImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

