/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.services;

import java.util.Optional;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.services.ServiceType;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeAddress;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServicePort;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerService
extends ServiceType {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerService.class);
    public static final LoadBalancerService INSTANCE = new LoadBalancerService();

    @Override
    public Service buildUpInternalService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Endpoint> getRestEndpoint(Service targetService, NamespacedKubernetesClient internalClient, KubernetesConfigOptions.NodePortAddressType nodePortAddressType) {
        int restPort = this.getRestPortFromExternalService(targetService);
        return this.getRestEndPointFromService(internalClient, nodePortAddressType, targetService, restPort);
    }

    @Override
    public int getRestPort(ServicePort port) {
        return port.getPort();
    }

    @Override
    public String getType() {
        return KubernetesConfigOptions.ServiceExposedType.LoadBalancer.name();
    }

    private Optional<Endpoint> getRestEndPointFromService(NamespacedKubernetesClient internalClient, KubernetesConfigOptions.NodePortAddressType nodePortAddressType, Service service, int restPort) {
        if (service.getStatus() == null) {
            return Optional.empty();
        }
        LoadBalancerStatus loadBalancer = service.getStatus().getLoadBalancer();
        if (loadBalancer != null) {
            return this.getLoadBalancerRestEndpoint(internalClient, nodePortAddressType, loadBalancer, restPort);
        }
        return Optional.empty();
    }

    private Optional<Endpoint> getLoadBalancerRestEndpoint(NamespacedKubernetesClient internalClient, KubernetesConfigOptions.NodePortAddressType nodePortAddressType, LoadBalancerStatus loadBalancer, int restPort) {
        String address;
        boolean hasIngress;
        boolean bl = hasIngress = loadBalancer.getIngress() != null && !loadBalancer.getIngress().isEmpty();
        if (hasIngress) {
            address = loadBalancer.getIngress().get(0).getIp();
            if (address == null || address.isEmpty()) {
                address = loadBalancer.getIngress().get(0).getHostname();
            }
        } else {
            address = ((NodeList)internalClient.nodes().list()).getItems().stream().filter(node -> node.getSpec().getUnschedulable() == null || node.getSpec().getUnschedulable() == false).flatMap(node -> node.getStatus().getAddresses().stream()).filter(nodeAddress -> nodePortAddressType.name().equals(nodeAddress.getType())).map(NodeAddress::getAddress).filter(ip -> !ip.isEmpty()).findAny().orElse(null);
            if (address == null) {
                LOG.warn("Unable to find any node ip with type [{}]. Please see [{}] config option for more details.", (Object)nodePortAddressType, (Object)KubernetesConfigOptions.REST_SERVICE_EXPOSED_NODE_PORT_ADDRESS_TYPE.key());
            }
        }
        boolean noAddress = address == null || address.isEmpty();
        return noAddress ? Optional.empty() : Optional.of(new Endpoint(address, restPort));
    }
}

