/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Readiable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitOperationContext;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
implements ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<List<HasMetadata>, HasMetadata>,
Readiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.class);
    protected static final String EXPRESSION = "expression";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final NamespaceVisitOperationContext namespaceVisitOperationContext;
    private OperationContext context;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        this.namespaceVisitOperationContext = namespaceVisitOperationContext;
        this.context = context;
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(ClientContext clientContext, Object item) {
        this(HasMetadataOperationsImpl.defaultContext(clientContext).withItem(item), new NamespaceVisitOperationContext());
    }

    @Override
    public List<HasMetadata> waitUntilReady(long amount, TimeUnit timeUnit) {
        return this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    List<HasMetadata> getItems() {
        Object item = this.context.getItem();
        if (item instanceof InputStream) {
            item = Serialization.unmarshal((InputStream)item, Collections.emptyMap());
            this.context = this.context.withItem(item);
        }
        return this.asHasMetadata(item).stream().map(meta -> NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(meta, Collections.emptyList(), this.namespaceVisitOperationContext.getExplicitNamespace(), this.context)).collect(Collectors.toList());
    }

    List<NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl> getOperations() {
        return this.getItems().stream().map(meta -> new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.context.withItem(meta), this.namespaceVisitOperationContext)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HasMetadata> waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        List<NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl> operations = this.getOperations();
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService executor = Executors.newFixedThreadPool(operations.size(), Utils.daemonThreadFactory(this));
        try {
            List items = operations.stream().map(o -> o.get()).collect(Collectors.toList());
            ArrayList<CompletableFuture<HasMetadata>> futures = new ArrayList<CompletableFuture<HasMetadata>>(items.size());
            for (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl impl : operations) {
                futures.add(CompletableFuture.supplyAsync(() -> impl.waitUntilCondition((Predicate)condition, amount, timeUnit)));
            }
            ArrayList<HasMetadata> results = new ArrayList<HasMetadata>();
            ArrayList<HasMetadata> itemsWithConditionNotMatched = new ArrayList<HasMetadata>();
            for (int i = 0; i < items.size(); ++i) {
                HasMetadata meta = (HasMetadata)items.get(i);
                try {
                    CompletableFuture future = (CompletableFuture)futures.get(i);
                    results.add((HasMetadata)future.get());
                    continue;
                }
                catch (ExecutionException e) {
                    itemsWithConditionNotMatched.add(meta);
                    NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.logAsNotReady(e.getCause(), meta);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
            if (!itemsWithConditionNotMatched.isEmpty()) {
                throw new KubernetesClientTimeoutException(itemsWithConditionNotMatched, amount, timeUnit);
            }
            ArrayList<HasMetadata> arrayList = results;
            return arrayList;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static void logAsNotReady(Throwable t, HasMetadata meta) {
        LOGGER.warn("Error while waiting for: [{}] with name: [{}] in namespace: [{}]: {}. The resource will be considered not ready.", new Object[]{meta.getKind(), meta.getMetadata().getName(), meta.getMetadata().getNamespace(), t.getMessage()});
        LOGGER.debug("The error stack trace:", t);
    }

    @Override
    public boolean isReady() {
        return this.getOperations().stream().map(impl -> impl.get()).allMatch(meta -> this.getReadiness().isReady((HasMetadata)meta));
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> withParameters(Map<String, String> parameters) {
        Object item = Serialization.unmarshal((InputStream)this.context.getItem(), parameters);
        return this.newInstance(this.context.withItem(item), this.namespaceVisitOperationContext);
    }

    @Override
    public ListVisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun), this.namespaceVisitOperationContext);
    }

    @Override
    public List<HasMetadata> apply() {
        return this.createOrReplace();
    }

    @Override
    public List<HasMetadata> createOrReplace() {
        return this.getOperations().stream().map(impl -> impl.createOrReplace()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> createOrReplaceAnd() {
        return this.newInstance(this.context.withItem(this.createOrReplace()), this.namespaceVisitOperationContext);
    }

    @Override
    public Boolean delete() {
        for (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl impl : this.getOperations()) {
            if (!Boolean.FALSE.equals(impl.delete())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HasMetadata> get() {
        return this.getOperations().stream().map(impl -> impl.get()).collect(Collectors.toList());
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        return this.newInstance(this.context.withNamespace(explicitNamespace), this.namespaceVisitOperationContext.withExplicitNamespace(explicitNamespace));
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true), this.namespaceVisitOperationContext);
    }

    @Override
    public Applicable<List<HasMetadata>> deletingExisting() {
        return this.newInstance(this.context, this.namespaceVisitOperationContext.withDeletingExisting(true));
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        return this.newInstance(this.context.withItem(this.getOperations().stream().map(oper -> (HasMetadata)oper.accept(visitors).get()).collect(Collectors.toList())), this.namespaceVisitOperationContext);
    }

    @Override
    public CascadingDeletable<List<HasMetadata>> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds), this.namespaceVisitOperationContext);
    }

    @Override
    public CascadingDeletable<List<HasMetadata>> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy), this.namespaceVisitOperationContext);
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        return this;
    }

    @Override
    public Deletable cascading(boolean cascading) {
        return this.newInstance(this.context.withCascading(cascading), this.namespaceVisitOperationContext);
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    protected List<HasMetadata> asHasMetadata(Object item) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
        } else if (item instanceof KubernetesResourceList) {
            result.addAll(((KubernetesResourceList)item).getItems());
        } else if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
        } else {
            if (item instanceof String) {
                return this.asHasMetadata(Serialization.unmarshal((String)item));
            }
            if (item instanceof Collection) {
                for (Object o : (Collection)item) {
                    if (!(o instanceof HasMetadata)) continue;
                    result.add((HasMetadata)o);
                }
            } else if (item != null) {
                throw new IllegalArgumentException("Could not convert item to a list of HasMetadata");
            }
        }
        return result;
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl newInstance(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(context, namespaceVisitOperationContext);
    }
}

