/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.ShortValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class ShortValueSummaryAggregatorTest
extends ShortSummaryAggregatorTest {
    ShortValueSummaryAggregatorTest() {
    }

    @Override
    protected NumericColumnSummary<Short> summarize(Integer ... values) {
        ShortValue[] shortValues = new ShortValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            shortValues[i] = new ShortValue(values[i].shortValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<ShortValue, NumericColumnSummary<Short>, ValueSummaryAggregator.ShortValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Short> result1, NumericColumnSummary<Short> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((short)((Short)result2.getMin())).isEqualTo(((Short)result1.getMin()).shortValue());
                Assertions.assertThat((short)((Short)result2.getMax())).isEqualTo(((Short)result1.getMax()).shortValue());
                Assertions.assertThat((short)((Short)result2.getSum())).isEqualTo(((Short)result1.getSum()).shortValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(shortValues);
    }
}

