/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.DoubleValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class DoubleValueSummaryAggregatorTest
extends DoubleSummaryAggregatorTest {
    DoubleValueSummaryAggregatorTest() {
    }

    @Override
    protected NumericColumnSummary<Double> summarize(Double ... values) {
        DoubleValue[] doubleValues = new DoubleValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            doubleValues[i] = new DoubleValue(values[i].doubleValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<DoubleValue, NumericColumnSummary<Double>, ValueSummaryAggregator.DoubleValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Double> result1, NumericColumnSummary<Double> result2) {
                Assertions.assertThat((Double)((Double)result2.getMin())).isCloseTo((Double)result1.getMin(), Offset.offset((Number)0.0));
                Assertions.assertThat((Double)((Double)result2.getMax())).isCloseTo((Double)result1.getMax(), Offset.offset((Number)0.0));
                Assertions.assertThat((Double)result2.getMean()).isCloseTo(result1.getMean(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((Double)result2.getVariance()).isCloseTo(result1.getVariance(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((Double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(doubleValues);
    }
}

