/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregateTranslationTest {
    AggregateTranslationTest() {
    }

    @Test
    void translateAggregate() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSource initialData = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)77L)});
            initialData.groupBy(new int[]{0}).aggregate(Aggregations.MIN, 1).and(Aggregations.SUM, 2).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            GroupReduceOperatorBase reducer = (GroupReduceOperatorBase)sink.getInput();
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{0});
            Assertions.assertThat((int)reducer.getParallelism()).isEqualTo(-1);
            Assertions.assertThat((boolean)reducer.isCombinable()).isTrue();
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }
}

