/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SortPartitionTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.createTypeInfo(CustomType.class), BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();
    private final List<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomData = new ArrayList<Tuple4<Integer, Long, CustomType, Long[]>>();

    SortPartitionTest() {
    }

    @Test
    void testSortPartitionPositionKeys1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition(0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionPositionKeys2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition(0, Order.ASCENDING).sortPartition(3, Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionWithPositionKeys3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithPositionKeys3$0((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionWithPositionKeys4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithPositionKeys4$1((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionExpressionKeys1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition("f1", Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionExpressionKeys2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition("f0", Order.ASCENDING).sortPartition("f2.nested.myInt", Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionWithExpressionKeys3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithExpressionKeys3$2((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionWithExpressionKeys4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithExpressionKeys4$3((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition((KeySelector & Serializable)value -> (Integer)value.f0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithKeySelector2$4((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithKeySelector3$5((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSortPartitionWithKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Tuple2<Integer, Long>>(){

                public Tuple2<Integer, Long> getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                    return new Tuple2(value.f0, value.f1);
                }
            }, Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortPartitionWithKeySelector5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        Assertions.assertThatThrownBy(() -> SortPartitionTest.lambda$testSortPartitionWithKeySelector5$6((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithKeySelector5$6(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition((KeySelector & Serializable)value -> (CustomType)value.f2, Order.ASCENDING).sortPartition("f1", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithKeySelector3$5(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition("f1", Order.ASCENDING).sortPartition((KeySelector & Serializable)value -> (CustomType)value.f2, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithKeySelector2$4(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition((KeySelector & Serializable)value -> (Long[])value.f3, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithExpressionKeys4$3(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition("f3", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithExpressionKeys3$2(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition("f2.nested", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithPositionKeys4$1(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition(3, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testSortPartitionWithPositionKeys3$0(DataSet tupleDs) throws Throwable {
        tupleDs.sortPartition(2, Order.ASCENDING);
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nest nested;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }

        public static class Nest {
            public int myInt;
        }
    }
}

