/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReduceOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    ReduceOperatorTest() {
    }

    @Test
    void testSemanticPropsWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        ReduceOperator reduceOp = tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).reduce((ReduceFunction)new DummyReduceFunction1());
        SingleInputSemanticProperties semProps = reduceOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 0)).isLessThan(0);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 1)).isEqualTo(3);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 2)).isEqualTo(4);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 3)).isEqualTo(3);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 4)).isEqualTo(2);
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 5, 6});
    }

    @Test
    void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        ReduceOperator reduceOp = (ReduceOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).reduce((ReduceFunction)new DummyReduceFunction2()).withForwardedFields(new String[]{"0->4;1;1->3;2"});
        SingleInputSemanticProperties semProps = reduceOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 0)).isLessThan(0);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 1)).isEqualTo(3);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 2)).isEqualTo(4);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 3)).isEqualTo(3);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 4)).isEqualTo(2);
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 5, 6});
    }

    @Test
    void testSemanticPropsWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        ReduceOperator reduceOp = (ReduceOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).reduce((ReduceFunction)new DummyReduceFunction3()).withForwardedFields(new String[]{"4->0;3;3->1;2"});
        SingleInputSemanticProperties semProps = reduceOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 0)).isEqualTo(6);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 1)).isEqualTo(5);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 2)).isEqualTo(4);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 3)).isEqualTo(5);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 4)).isLessThan(0);
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).isNull();
    }

    @Test
    void testSemanticPropsWithKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        ReduceOperator reduceOp = tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).reduce((ReduceFunction)new DummyReduceFunction4());
        SingleInputSemanticProperties semProps = reduceOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 0)).isEqualTo(2);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 1)).isEqualTo(3);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 2)).isLessThan(0);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 3)).isEqualTo(5);
        Assertions.assertThat((int)semProps.getForwardingSourceField(0, 4)).isLessThan(0);
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).isNull();
    }

    @FunctionAnnotation.NonForwardedFields(value={"2;4"})
    private static class DummyReduceFunction4
    implements ReduceFunction<Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyReduceFunction4() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> reduce(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return new Tuple5();
        }
    }

    private static class DummyReduceFunction3
    implements ReduceFunction<Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyReduceFunction3() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> reduce(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return new Tuple5();
        }
    }

    @FunctionAnnotation.ReadFields(value={"0;3;4"})
    private static class DummyReduceFunction2
    implements ReduceFunction<Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyReduceFunction2() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> reduce(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return new Tuple5();
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->4;1;1->3;2"})
    @FunctionAnnotation.ReadFields(value={"0;3;4"})
    private static class DummyReduceFunction1
    implements ReduceFunction<Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyReduceFunction1() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> reduce(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return new Tuple5();
        }
    }

    private static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        private DummyTestKeySelector() {
        }

        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }
}

