/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProjectionOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();

    ProjectionOperatorTest() {
    }

    @Test
    void testFieldsProjection() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.project(new int[]{0});
        Assertions.assertThatThrownBy(() -> ProjectionOperatorTest.lambda$testFieldsProjection$0((DataSet)tupleDs)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> ProjectionOperatorTest.lambda$testFieldsProjection$1((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> ProjectionOperatorTest.lambda$testFieldsProjection$2((DataSet)longDs)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testProjectionTypes() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.project(new int[]{0});
        tupleDs.project(new int[]{2, 1, 4});
    }

    @Test
    void testProjectionWithoutTypes() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.project(new int[]{2, 0, 4});
        Assertions.assertThatThrownBy(() -> ProjectionOperatorTest.lambda$testProjectionWithoutTypes$3((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> ProjectionOperatorTest.lambda$testProjectionWithoutTypes$4((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    private static /* synthetic */ void lambda$testProjectionWithoutTypes$4(DataSet tupleDs) throws Throwable {
        tupleDs.project(new int[]{2, 1, 4, 5, 8, 9});
    }

    private static /* synthetic */ void lambda$testProjectionWithoutTypes$3(DataSet tupleDs) throws Throwable {
        tupleDs.project(new int[]{2, -1, 4});
    }

    private static /* synthetic */ void lambda$testFieldsProjection$2(DataSet longDs) throws Throwable {
        longDs.project(new int[]{0});
    }

    private static /* synthetic */ void lambda$testFieldsProjection$1(DataSet tupleDs) throws Throwable {
        tupleDs.project(new int[]{0, 5, 2});
    }

    private static /* synthetic */ void lambda$testFieldsProjection$0(DataSet tupleDs) throws Throwable {
        tupleDs.project(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25});
    }
}

