/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionOperatorTest {
    PartitionOperatorTest() {
    }

    private DataSet<Tuple2<Integer, String>> getTupleDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1, (Object)"first"), new Tuple2((Object)2, (Object)"second"), new Tuple2((Object)3, (Object)"third"), new Tuple2((Object)4, (Object)"fourth"), new Tuple2((Object)5, (Object)"fifth"), new Tuple2((Object)6, (Object)"sixth")});
    }

    private DataSet<CustomPojo> getPojoDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new CustomPojo[]{new CustomPojo(1, "first"), new CustomPojo(2, "second"), new CustomPojo(3, "third"), new CustomPojo(4, "fourth"), new CustomPojo(5, "fifth"), new CustomPojo(6, "sixth")});
    }

    private DataSet<NestedPojo> getNestedPojoDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new NestedPojo[]{new NestedPojo(new CustomPojo(1, "first"), 1L), new NestedPojo(new CustomPojo(2, "second"), 2L), new NestedPojo(new CustomPojo(3, "third"), 3L), new NestedPojo(new CustomPojo(4, "fourth"), 4L), new NestedPojo(new CustomPojo(5, "fifth"), 5L), new NestedPojo(new CustomPojo(6, "sixth"), 6L)});
    }

    @Test
    void testRebalance() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.rebalance();
    }

    @Test
    void testHashPartitionByField1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{0});
    }

    @Test
    void testHashPartitionByField2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{0, 1});
    }

    @Test
    void testHashPartitionByFieldOutOfRange() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByHash(new int[]{0, 1, 2})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testHashPartitionByFieldName1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByHash(new String[]{"number"});
    }

    @Test
    void testHashPartitionByFieldName2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByHash(new String[]{"number", "name"});
    }

    @Test
    void testHashPartitionByInvalidFieldName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByHash(new String[]{"number", "name", "invalidField"})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionByFieldName1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByRange(new String[]{"number"});
    }

    @Test
    void testRangePartitionByFieldName2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByRange(new String[]{"number", "name"});
    }

    @Test
    void testRangePartitionByInvalidFieldName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByRange(new String[]{"number", "name", "invalidField"})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionByField1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0});
    }

    @Test
    void testRangePartitionByField2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0, 1});
    }

    @Test
    void testRangePartitionWithEmptyIndicesKey() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        Assertions.assertThatThrownBy(() -> ds.partitionByRange(new int[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionByFieldOutOfRange() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByRange(new int[]{0, 1, 2})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testHashPartitionWithOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByHash(new int[]{1}).withOrders(new Order[]{Order.ASCENDING})).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRebalanceWithOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.rebalance().withOrders(new Order[]{Order.ASCENDING})).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRangePartitionWithOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING});
    }

    @Test
    void testRangePartitionWithTooManyOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionByComplexKeyWithOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        ds.partitionByRange(new int[]{0, 1}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING});
    }

    @Test
    void testRangePartitionByComplexKeyWithTooManyOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        Assertions.assertThatThrownBy(() -> ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionBySelectorComplexKeyWithOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<NestedPojo> ds = this.getNestedPojoDataSet(env);
        ds.partitionByRange(NestedPojo::getNested).withOrders(new Order[]{Order.ASCENDING});
    }

    @Test
    void testRangePartitionBySelectorComplexKeyWithTooManyOrders() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<NestedPojo> ds = this.getNestedPojoDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionByRange((KeySelector & Serializable)value -> value.getNested()).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRangePartitionCustomPartitionerByFieldId() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionCustom((Partitioner & Serializable)(key, numPartitions) -> 1, 0);
    }

    @Test
    void testRangePartitionInvalidCustomPartitionerByFieldId() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionCustom((Partitioner & Serializable)(key, numPartitions) -> 1, 1)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testRangePartitionCustomPartitionerByFieldName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionCustom((Partitioner & Serializable)(key, numPartitions) -> 1, "number");
    }

    @Test
    void testRangePartitionInvalidCustomPartitionerByFieldName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        Assertions.assertThatThrownBy(() -> ds.partitionCustom((Partitioner & Serializable)(key, numPartitions) -> 1, "name")).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testRangePartitionCustomPartitionerByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionCustom((Partitioner & Serializable)(key, numPartitions) -> 1, CustomPojo::getNumber);
    }

    public static class NestedPojo
    implements Serializable {
        private CustomPojo nested;
        private Long outer;

        public NestedPojo() {
        }

        public NestedPojo(CustomPojo nested, Long outer) {
            this.nested = nested;
            this.outer = outer;
        }

        public CustomPojo getNested() {
            return this.nested;
        }

        public void setNested(CustomPojo nested) {
            this.nested = nested;
        }

        public Long getOuter() {
            return this.outer;
        }

        public void setOuter(Long outer) {
            this.outer = outer;
        }
    }

    public static class CustomPojo
    implements Serializable,
    Comparable<CustomPojo> {
        private Integer number;
        private String name;

        public CustomPojo() {
        }

        public CustomPojo(Integer number, String name) {
            this.number = number;
            this.name = name;
        }

        public Integer getNumber() {
            return this.number;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(CustomPojo o) {
            return Integer.compare(this.number, o.number);
        }
    }
}

