/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class JoinOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>> emptyNestedTupleData = new ArrayList<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>> nestedTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<Tuple5<CustomType, Long, String, Long, Integer>> emptyNestedCustomTupleData = new ArrayList<Tuple5<CustomType, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<CustomType, Long, String, Long, Integer>> nestedCustomTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{TypeExtractor.getForClass(CustomType.class), BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<CustomTypeWithTuple> customTypeWithTupleData = new ArrayList<CustomTypeWithTuple>();
    private static final List<CustomType> customTypeData = new ArrayList<CustomType>();
    private static final List<NestedCustomType> customNestedTypeData = new ArrayList<NestedCustomType>();

    JoinOperatorTest() {
    }

    @BeforeAll
    static void insertCustomData() {
        customTypeData.add(new CustomType());
        customTypeWithTupleData.add(new CustomTypeWithTuple());
        customNestedTypeData.add(new NestedCustomType());
    }

    @Test
    void testJoinKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyFields2$0((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyFields3$1((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyFields4$2((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyFields5$3((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyFields6$4((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyExpressionsNested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customNestedTypeData);
        DataSource ds2 = env.fromCollection(customNestedTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions2$5((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions3$6((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions4$7((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testJoinKeyMixedKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo((KeySelector)new KeySelector<CustomType, Integer>(){

                public Integer getKey(CustomType value) throws Exception {
                    return value.myInt;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixedKeySelectorTurned() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Integer>(){

                public Integer getKey(CustomType value) throws Exception {
                    return value.myInt;
                }
            }).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixedTupleIndex() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"f0"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyNestedTuples() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedTupleData, this.nestedTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"f0.f0"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyNestedTuplesWithCustom() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedCustomTupleData, this.nestedCustomTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            TypeInformation t = ds1.join((DataSet)ds2).where(new String[]{"f0.myInt"}).equalTo(new int[]{4}).getType();
            ((ObjectAssert)Assertions.assertThat((Object)t).as("not a composite type", new Object[0])).isInstanceOf(CompositeType.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyWithCustomContainingTuple0() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"intByString.f0"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyWithCustomContainingTuple1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"intByString.f0"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyWithCustomContainingTuple2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt", "myInt", "intByString.f1"}).equalTo(new String[]{"intByString.f0", "myInt", "myString"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyNestedTuplesWrongType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedTupleData, this.nestedTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyNestedTuplesWrongType$8((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyMixedTupleIndexTurned() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"f0"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixedTupleIndexWrongType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyMixedTupleIndexWrongType$9((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyMixedTupleIndex2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixedWrong() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyMixedWrong$10((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions2Nested$11((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions3Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions3Nested$12((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyExpressions4Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyExpressions4Nested$13((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testJoinKeySelectors1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo((KeySelector & Serializable)value -> value.myLong);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixing1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo(new int[]{3});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixing2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new int[]{3}).equalTo((KeySelector & Serializable)value -> value.myLong);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinKeyMixing3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyMixing3$14((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyMixing4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyMixing4$15((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyAtomic1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"*"}).equalTo(new int[]{0});
    }

    @Test
    void testJoinKeyAtomic2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"*"});
    }

    @Test
    void testJoinKeyInvalidAtomic1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic1$16((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyInvalidAtomic2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic2$17((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyInvalidAtomic3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic3$18((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyInvalidAtomic4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic4$19((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyInvalidAtomic5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic5$20((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinKeyInvalidAtomic6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinKeyInvalidAtomic6$21((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testJoinProjection1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection21() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{-1});
            Assertions.fail(null);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).project(new int[]{9});
            Assertions.fail(null);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo((KeySelector & Serializable)value -> value.myLong).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            System.out.println("FAILED: " + e);
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection26() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo((KeySelector & Serializable)value -> value.myLong).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            System.out.println("FAILED: " + e);
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection27() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testJoinProjection8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection8$22((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection28() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection28$23((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection9$24((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection29() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection29$25((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    void testJoinProjection10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2});
    }

    @Test
    void testJoinProjection30() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection30$26((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    void testJoinProjection11() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{2});
    }

    void testJoinProjection12() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{2}).projectFirst(new int[]{1});
    }

    @Test
    void testJoinProjection13() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection13$27((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection33() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection33$28((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection14() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection14$29((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testJoinProjection34() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> JoinOperatorTest.lambda$testJoinProjection34$30((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSemanticPropsWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator.EquiJoin joinOp = tupleDs1.join((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((JoinFunction)new DummyTestJoinFunction1());
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 2)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 6)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 4, 6});
        Assertions.assertThat((Iterable)semProps.getReadFields(1)).containsExactly((Object[])new Integer[]{5, 3});
    }

    @Test
    void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator joinOp = (JoinOperator)((JoinOperator)tupleDs1.join((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((JoinFunction)new DummyTestJoinFunction2()).withForwardedFieldsFirst(new String[]{"2;4->0"})).withForwardedFieldsSecond(new String[]{"0->4;1;1->3"});
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 4)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 6)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 3, 4});
        Assertions.assertThat((Iterable)semProps.getReadFields(1)).isNull();
    }

    @Test
    void testSemanticPropsWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator.ProjectJoin joinOp = tupleDs1.join((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).projectFirst(new int[]{2}).projectSecond(new int[]{0, 0, 3}).projectFirst(new int[]{0, 4}).projectSecond(new int[]{2});
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).containsExactly((Object[])new Integer[]{5});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 4)).containsExactly((Object[])new Integer[]{6});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 5)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 6)).isEmpty();
    }

    private static /* synthetic */ void lambda$testJoinProjection34$30(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testJoinProjection14$29(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinProjection33$28(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{-1}).projectFirst(new int[]{3});
    }

    private static /* synthetic */ void lambda$testJoinProjection13$27(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{0}).projectFirst(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinProjection30$26(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testJoinProjection29$25(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinProjection9$24(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinProjection28$23(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinProjection8$22(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{5});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic6$21(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic5$20(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic4$19(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new String[]{"invalidKey"});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic3$18(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"invalidKey"});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic2$17(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new String[]{"*", "invalidKey"});
    }

    private static /* synthetic */ void lambda$testJoinKeyInvalidAtomic1$16(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"*", "invalidKey"});
    }

    private static /* synthetic */ void lambda$testJoinKeyMixing4$15(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{1, 3}).equalTo((KeySelector & Serializable)value -> value.myLong);
    }

    private static /* synthetic */ void lambda$testJoinKeyMixing3$14(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{2}).equalTo((KeySelector & Serializable)value -> value.myLong);
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions4Nested$13(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"nested.myNonExistent"}).equalTo(new String[]{"nested.myInt"});
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions3Nested$12(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"nested.myInt", "nested.myString"}).equalTo(new String[]{"nested.myString"});
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions2Nested$11(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myString"});
    }

    private static /* synthetic */ void lambda$testJoinKeyMixedWrong$10(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"myString"}).equalTo((KeySelector & Serializable)value -> value.myInt);
    }

    private static /* synthetic */ void lambda$testJoinKeyMixedTupleIndexWrongType$9(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"f0"}).equalTo(new int[]{3});
    }

    private static /* synthetic */ void lambda$testJoinKeyNestedTuplesWrongType$8(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"f0.f1"}).equalTo(new int[]{4});
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions4$7(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"myNonExistent"}).equalTo(new String[]{"myInt"});
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions3$6(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"myInt", "myString"}).equalTo(new String[]{"myString"});
    }

    private static /* synthetic */ void lambda$testJoinKeyExpressions2$5(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myString"});
    }

    private static /* synthetic */ void lambda$testJoinKeyFields6$4(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{4}).equalTo(new int[]{0});
    }

    private static /* synthetic */ void lambda$testJoinKeyFields5$3(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{-1}).equalTo(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testJoinKeyFields4$2(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    private static /* synthetic */ void lambda$testJoinKeyFields3$1(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0, 1}).equalTo(new int[]{2});
    }

    private static /* synthetic */ void lambda$testJoinKeyFields2$0(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{2});
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"0;1;2"})
    private static class DummyTestJoinFunction2
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyTestJoinFunction2() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> join(Tuple5<Integer, Long, String, Long, Integer> first, Tuple5<Integer, Long, String, Long, Integer> second) throws Exception {
            return new Tuple5();
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->4;1;1->3"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"2;4->0"})
    @FunctionAnnotation.ReadFieldsFirst(value={"0;2;4"})
    @FunctionAnnotation.ReadFieldsSecond(value={"1;3"})
    private static class DummyTestJoinFunction1
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyTestJoinFunction1() {
        }

        public Tuple5<Integer, Long, String, Long, Integer> join(Tuple5<Integer, Long, String, Long, Integer> first, Tuple5<Integer, Long, String, Long, Integer> second) throws Exception {
            return new Tuple5();
        }
    }

    private static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        private DummyTestKeySelector() {
        }

        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }

    public static class CustomTypeWithTuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public NestedCustomType nested;
        public String myString;
        public Tuple2<Integer, String> intByString;

        public CustomTypeWithTuple() {
        }

        public CustomTypeWithTuple(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
            this.nested = new NestedCustomType(i, l, s);
            this.intByString = new Tuple2((Object)i, (Object)s);
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public NestedCustomType nested;
        public String myString;
        public Object nothing;
        public List<String> countries;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
            this.countries = null;
            this.nested = new NestedCustomType(i, l, s);
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }

    public static class NestedCustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nested nest;

        public NestedCustomType() {
        }

        public NestedCustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString + "," + this.nest;
        }
    }

    public static class Nested
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;

        public Nested() {
        }

        public Nested(int i, long l, String s) {
            this.myInt = i;
        }

        public String toString() {
            return "" + this.myInt;
        }
    }
}

