/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.BinaryInputFormat;
import org.apache.flink.api.common.io.BinaryOutputFormat;
import org.apache.flink.api.common.io.BlockInfo;
import org.apache.flink.api.common.io.SequentialFormatTestBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.io.TypeSerializerInputFormat;
import org.apache.flink.api.java.io.TypeSerializerOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

class TypeSerializerFormatTest
extends SequentialFormatTestBase<Tuple2<Integer, String>> {
    TypeInformation<Tuple2<Integer, String>> resultType = TypeExtractor.getForObject(this.getRecord(0));
    private final TypeSerializer<Tuple2<Integer, String>> serializer = this.resultType.createSerializer(new ExecutionConfig());
    private BlockInfo block;

    TypeSerializerFormatTest() {
    }

    @BeforeEach
    void setup() {
        this.block = this.createInputFormat().createBlockInfo();
    }

    @Override
    protected BinaryInputFormat<Tuple2<Integer, String>> createInputFormat() {
        Configuration configuration = new Configuration();
        TypeSerializerInputFormat inputFormat = new TypeSerializerInputFormat(this.resultType);
        inputFormat.setFilePath(this.tempFile.toURI().toString());
        inputFormat.setBlockSize(this.blockSize);
        inputFormat.configure(configuration);
        return inputFormat;
    }

    @Override
    protected BinaryOutputFormat<Tuple2<Integer, String>> createOutputFormat(String path, Configuration configuration) throws IOException {
        TypeSerializerOutputFormat outputFormat = new TypeSerializerOutputFormat();
        outputFormat.setSerializer(this.serializer);
        outputFormat.setOutputFilePath(new Path(path));
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        configuration = configuration == null ? new Configuration() : configuration;
        outputFormat.configure(configuration);
        outputFormat.open(0, 1);
        return outputFormat;
    }

    @Override
    protected int getInfoSize() {
        return this.block.getInfoSize();
    }

    @Override
    protected Tuple2<Integer, String> getRecord(int index) {
        return new Tuple2((Object)index, (Object)String.valueOf(index));
    }

    @Override
    protected Tuple2<Integer, String> createInstance() {
        return new Tuple2();
    }

    @Override
    protected void writeRecord(Tuple2<Integer, String> record, DataOutputView outputView) throws IOException {
        this.serializer.serialize(record, outputView);
    }

    @Override
    protected void checkEquals(Tuple2<Integer, String> expected, Tuple2<Integer, String> actual) {
        Assertions.assertThat((Integer)((Integer)actual.f0)).isEqualTo(expected.f0);
        Assertions.assertThat((String)((String)actual.f1)).isEqualTo((String)expected.f1);
    }
}

