/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TextInputFormatTest {
    TextInputFormatTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSimpleRead(@TempDir File tempDir) throws IOException {
        String first = "First line";
        String second = "Second line";
        File tempFile = File.createTempFile("TextInputFormatTest", "tmp", tempDir);
        tempFile.setWritable(true);
        try (PrintStream ps = new PrintStream(tempFile);){
            ps.println("First line");
            ps.println("Second line");
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
        Configuration parameters = new Configuration();
        inputFormat.configure(parameters);
        Object[] splits = inputFormat.createInputSplits(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])splits).as("expected at least one input split", new Object[0])).isNotEmpty();
        inputFormat.open((FileInputSplit)splits[0]);
        try {
            Assertions.assertThat((boolean)inputFormat.reachedEnd()).isFalse();
            String result = (String)inputFormat.nextRecord((Object)"");
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting first record here", new Object[0])).isNotNull()).isEqualTo("First line");
            Assertions.assertThat((boolean)inputFormat.reachedEnd()).isFalse();
            result = (String)inputFormat.nextRecord((Object)result);
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting second record here", new Object[0])).isNotNull()).isEqualTo("Second line");
            Assertions.assertThat((inputFormat.reachedEnd() || null == inputFormat.nextRecord((Object)result) ? 1 : 0) != 0).isTrue();
        }
        finally {
            inputFormat.close();
        }
    }

    @Test
    void testNestedFileRead(@TempDir File parentDir) throws IOException {
        String[] dirs = new String[]{"first", "second"};
        ArrayList<String> expectedFiles = new ArrayList<String>();
        for (String dir : dirs) {
            FileInputSplit[] tmpDir = new File(parentDir, dir);
            Files.createDirectories(tmpDir.toPath(), new FileAttribute[0]);
            File tempFile = File.createTempFile("TextInputFormatTest", ".tmp", (File)tmpDir);
            expectedFiles.add(new Path(tempFile.getAbsolutePath()).makeQualified(FileSystem.getLocalFileSystem()).toString());
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(parentDir.toURI()));
        inputFormat.setNestedFileEnumeration(true);
        inputFormat.setNumLineSamples(10);
        Configuration config = new Configuration();
        config.setBoolean("recursive.file.enumeration", false);
        config.setString("delimited-format.numSamples", "20");
        inputFormat.configure(config);
        Assertions.assertThat((boolean)inputFormat.getNestedFileEnumeration()).isTrue();
        Assertions.assertThat((int)inputFormat.getNumLineSamples()).isEqualTo(10);
        FileInputSplit[] splits = inputFormat.createInputSplits(expectedFiles.size());
        ArrayList<String> paths = new ArrayList<String>();
        for (FileInputSplit split : splits) {
            paths.add(split.getPath().toString());
        }
        Collections.sort(expectedFiles);
        Collections.sort(paths);
        for (int i = 0; i < expectedFiles.size(); ++i) {
            Assertions.assertThat((String)((String)paths.get(i))).isEqualTo((String)expectedFiles.get(i));
        }
    }

    @Test
    void testRemovingTrailingCR(@TempDir File tmpFile) throws IOException {
        this.testRemovingTrailingCR(tmpFile, "\n", "\n");
        this.testRemovingTrailingCR(tmpFile, "\r\n", "\n");
        this.testRemovingTrailingCR(tmpFile, "|", "|");
        this.testRemovingTrailingCR(tmpFile, "|", "\n");
    }

    private void testRemovingTrailingCR(File tmpFile, String lineBreaker, String delimiter) throws IOException {
        String first = "First line";
        String second = "Second line";
        String content = first + lineBreaker + second + lineBreaker;
        File tempFile = File.createTempFile("TextInputFormatTest", "tmp", tmpFile);
        tempFile.setWritable(true);
        try (OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));){
            wrt.write(content);
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
        inputFormat.setFilePath(tempFile.toURI().toString());
        Configuration parameters = new Configuration();
        inputFormat.configure(parameters);
        inputFormat.setDelimiter(delimiter);
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        if (delimiter.equals("\n") && (lineBreaker.equals("\n") || lineBreaker.equals("\r\n")) || lineBreaker.equals(delimiter)) {
            String result = (String)inputFormat.nextRecord((Object)"");
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting first record here", new Object[0])).isNotNull()).isEqualTo(first);
            result = (String)inputFormat.nextRecord((Object)result);
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting second record here", new Object[0])).isNotNull()).isEqualTo(second);
            result = (String)inputFormat.nextRecord((Object)result);
            ((AbstractStringAssert)Assertions.assertThat((String)result).as("The input file is over", new Object[0])).isNull();
        } else {
            String result = (String)inputFormat.nextRecord((Object)"");
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting first record here", new Object[0])).isNotNull()).isEqualTo(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCompressedRead(@TempDir File tempDir) throws IOException {
        TextInputFormat.registerInflaterInputStreamFactory((String)"compressed", (InflaterInputStreamFactory)new InflaterInputStreamFactory<InputStream>(){

            public InputStream create(InputStream in) {
                return in;
            }

            public Collection<String> getCommonFileExtensions() {
                return Collections.singletonList("compressed");
            }
        });
        String first = "First line";
        String second = "Second line";
        File tempFile = File.createTempFile("TextInputFormatTest", ".compressed", tempDir);
        tempFile.setWritable(true);
        try (PrintStream ps = new PrintStream(tempFile);){
            ps.println("First line");
            ps.println("Second line");
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
        Configuration parameters = new Configuration();
        inputFormat.configure(parameters);
        Object[] splits = inputFormat.createInputSplits(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])splits).as("expected at least one input split", new Object[0])).isNotEmpty();
        inputFormat.open((FileInputSplit)splits[0]);
        try {
            Assertions.assertThat((boolean)inputFormat.reachedEnd()).isFalse();
            String result = (String)inputFormat.nextRecord((Object)"");
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting first record here", new Object[0])).isNotNull()).isEqualTo("First line");
            Assertions.assertThat((boolean)inputFormat.reachedEnd()).isFalse();
            Long currentOffset = inputFormat.getCurrentState();
            inputFormat.close();
            inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
            inputFormat.configure(parameters);
            inputFormat.reopen((FileInputSplit)splits[0], currentOffset);
            Assertions.assertThat((boolean)inputFormat.reachedEnd()).isFalse();
            result = (String)inputFormat.nextRecord((Object)result);
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result).as("Expecting second record here", new Object[0])).isNotNull()).isEqualTo("Second line");
            Assertions.assertThat((inputFormat.reachedEnd() || null == inputFormat.nextRecord((Object)result) ? 1 : 0) != 0).isTrue();
        }
        finally {
            inputFormat.close();
        }
    }
}

