/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.flink.api.java.io.PrimitiveInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PrimitiveInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");

    PrimitiveInputFormatTest() {
    }

    @Test
    void testStringInput() {
        try {
            String fileContent = "abc||def||||";
            FileInputSplit split = this.createInputSplit("abc||def||||");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "||", String.class);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            String result = null;
            result = (String)format.nextRecord(result);
            Assertions.assertThat((String)result).isEqualTo("abc");
            result = (String)format.nextRecord((Object)result);
            Assertions.assertThat((String)result).isEqualTo("def");
            result = (String)format.nextRecord((Object)result);
            Assertions.assertThat((String)result).isEmpty();
            result = (String)format.nextRecord((Object)result);
            Assertions.assertThat((String)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testIntegerInput() {
        try {
            String fileContent = "111|222|";
            FileInputSplit split = this.createInputSplit("111|222|");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "|", Integer.class);
            format.configure(new Configuration());
            format.open(split);
            Integer result = null;
            result = (Integer)format.nextRecord(result);
            Assertions.assertThat((Integer)result).isEqualTo((Object)111);
            result = (Integer)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)result).isEqualTo((Object)222);
            result = (Integer)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testDoubleInputLinewise() {
        try {
            String fileContent = "1.21\n2.23\n";
            FileInputSplit split = this.createInputSplit("1.21\n2.23\n");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, Double.class);
            format.configure(new Configuration());
            format.open(split);
            Double result = null;
            result = (Double)format.nextRecord(result);
            Assertions.assertThat((Double)result).isEqualTo(Double.valueOf(1.21));
            result = (Double)format.nextRecord((Object)result);
            Assertions.assertThat((Double)result).isEqualTo(Double.valueOf(2.23));
            result = (Double)format.nextRecord((Object)result);
            Assertions.assertThat((Double)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testRemovingTrailingCR() {
        try {
            String first = "First line";
            String second = "Second line";
            String fileContent = first + "\r\n" + second + "\r\n";
            FileInputSplit split = this.createInputSplit(fileContent);
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, String.class);
            format.configure(new Configuration());
            format.open(split);
            String result = null;
            result = (String)format.nextRecord(result);
            Assertions.assertThat((String)result).isEqualTo(first);
            result = (String)format.nextRecord((Object)result);
            Assertions.assertThat((String)result).isEqualTo(second);
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testFailingInput() throws IOException {
        String fileContent = "111|222|asdf|17";
        FileInputSplit split = this.createInputSplit("111|222|asdf|17");
        PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "|", Integer.class);
        format.configure(new Configuration());
        format.open(split);
        Integer result = null;
        result = (Integer)format.nextRecord(result);
        Assertions.assertThat((Integer)result).isEqualTo((Object)111);
        result = (Integer)format.nextRecord((Object)result);
        Assertions.assertThat((Integer)result).isEqualTo((Object)222);
        Integer finalResult = result;
        Assertions.assertThatThrownBy(() -> {
            Integer cfr_ignored_0 = (Integer)format.nextRecord((Object)finalResult);
        }).isInstanceOf(IOException.class);
    }

    private FileInputSplit createInputSplit(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        try (FileWriter wrt = new FileWriter(tempFile);){
            wrt.write(content);
        }
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }
}

