/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GroupReduceOperatorTest
implements Serializable {
    private static final TypeInformation<Tuple2<String, Integer>> STRING_INT_TUPLE = TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){});

    GroupReduceOperatorTest() {
    }

    @Test
    void testGroupReduceCollection() {
        try {
            GroupReduceFunction & Serializable reducer = (GroupReduceFunction & Serializable)(values, out) -> {
                Iterator input = values.iterator();
                Tuple2 result = (Tuple2)input.next();
                int sum = (Integer)result.f1;
                while (input.hasNext()) {
                    Tuple2 next = (Tuple2)input.next();
                    sum += ((Integer)next.f1).intValue();
                }
                result.f1 = sum;
                out.collect((Object)result);
            };
            GroupReduceOperatorBase op = new GroupReduceOperatorBase((GroupReduceFunction)reducer, new UnaryOperatorInformation(STRING_INT_TUPLE, STRING_INT_TUPLE), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, null, executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, null, executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assertions.assertThat(resultSetMutableSafe).isEqualTo(expectedResult);
            Assertions.assertThat(resultSetRegular).isEqualTo(expectedResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGroupReduceCollectionWithRuntimeContext() {
        try {
            String taskName = "Test Task";
            final AtomicBoolean opened = new AtomicBoolean();
            final AtomicBoolean closed = new AtomicBoolean();
            RichGroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>> reducer = new RichGroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){

                public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                    Iterator<Tuple2<String, Integer>> input = values.iterator();
                    Tuple2<String, Integer> result = input.next();
                    int sum = (Integer)result.f1;
                    while (input.hasNext()) {
                        Tuple2<String, Integer> next = input.next();
                        sum += ((Integer)next.f1).intValue();
                    }
                    result.f1 = sum;
                    out.collect(result);
                }

                public void open(Configuration parameters) throws Exception {
                    opened.set(true);
                    RuntimeContext ctx = this.getRuntimeContext();
                    Assertions.assertThat((int)ctx.getIndexOfThisSubtask()).isZero();
                    Assertions.assertThat((int)ctx.getNumberOfParallelSubtasks()).isOne();
                    Assertions.assertThat((String)ctx.getTaskName()).isEqualTo("Test Task");
                }

                public void close() throws Exception {
                    closed.set(true);
                }
            };
            GroupReduceOperatorBase op = new GroupReduceOperatorBase((GroupReduceFunction)reducer, new UnaryOperatorInformation(STRING_INT_TUPLE, STRING_INT_TUPLE), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            TaskInfo taskInfo = new TaskInfo("Test Task", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assertions.assertThat(resultSetMutableSafe).isEqualTo(expectedResult);
            Assertions.assertThat(resultSetRegular).isEqualTo(expectedResult);
            Assertions.assertThat((boolean)opened.get()).isTrue();
            Assertions.assertThat((boolean)closed.get()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

