/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import org.apache.flink.api.common.io.BinaryInputFormat;
import org.apache.flink.api.common.io.BinaryOutputFormat;
import org.apache.flink.api.common.io.BlockInfo;
import org.apache.flink.api.common.io.SequentialFormatTestBase;
import org.apache.flink.api.common.io.SerializedInputFormat;
import org.apache.flink.api.common.io.SerializedOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

class SerializedFormatTest
extends SequentialFormatTestBase<Record> {
    private BlockInfo info;

    SerializedFormatTest() {
    }

    @BeforeEach
    void setup() {
        this.info = this.createInputFormat().createBlockInfo();
    }

    @Override
    protected BinaryInputFormat<Record> createInputFormat() {
        Configuration configuration = new Configuration();
        SerializedInputFormat inputFormat = new SerializedInputFormat();
        inputFormat.setFilePath(this.tempFile.toURI().toString());
        inputFormat.setBlockSize(this.blockSize);
        inputFormat.configure(configuration);
        return inputFormat;
    }

    @Override
    protected BinaryOutputFormat<Record> createOutputFormat(String path, Configuration configuration) throws IOException {
        SerializedOutputFormat outputFormat = new SerializedOutputFormat();
        outputFormat.setOutputFilePath(new Path(path));
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        configuration = configuration == null ? new Configuration() : configuration;
        outputFormat.configure(configuration);
        outputFormat.open(0, 1);
        return outputFormat;
    }

    @Override
    protected int getInfoSize() {
        return this.info.getInfoSize();
    }

    @Override
    protected Record getRecord(int index) {
        return new Record((Value)new IntValue(index), (Value)new StringValue((CharSequence)String.valueOf(index)));
    }

    @Override
    protected Record createInstance() {
        return new Record();
    }

    @Override
    protected void writeRecord(Record record, DataOutputView outputView) throws IOException {
        record.write(outputView);
    }

    @Override
    protected void checkEquals(Record expected, Record actual) {
        Assertions.assertThat((int)actual.getNumFields()).isEqualTo(expected.getNumFields());
        Assertions.assertThat((Comparable)((Comparable)actual.getField(0, IntValue.class))).isEqualTo((Object)expected.getField(0, IntValue.class));
        Assertions.assertThat((CharSequence)((CharSequence)actual.getField(1, StringValue.class))).isEqualTo((Object)expected.getField(1, StringValue.class));
    }
}

