/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.operators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.RecordOperator;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.OperatorInfoHelper;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;

public class ReduceOperator
extends GroupReduceOperatorBase<Record, Record, GroupReduceFunction<Record, Record>>
implements RecordOperator {
    private static final String DEFAULT_NAME = "<Unnamed Reducer>";
    private final Class<? extends Key<?>>[] keyTypes;
    private final UserCodeWrapper<ReduceFunction> originalFunction;

    public static Builder builder(ReduceFunction udf) {
        UserCodeObjectWrapper original = new UserCodeObjectWrapper((Object)udf);
        UserCodeObjectWrapper wrapped = new UserCodeObjectWrapper((Object)new WrappingReduceFunction(udf));
        return new Builder((UserCodeWrapper)original, (UserCodeWrapper)wrapped);
    }

    public static Builder builder(ReduceFunction udf, Class<? extends Key<?>> keyClass, int keyColumn) {
        UserCodeObjectWrapper original = new UserCodeObjectWrapper((Object)udf);
        UserCodeObjectWrapper wrapped = new UserCodeObjectWrapper((Object)new WrappingReduceFunction(udf));
        return new Builder((UserCodeWrapper)original, (UserCodeWrapper)wrapped, keyClass, keyColumn);
    }

    public static Builder builder(Class<? extends ReduceFunction> udf) {
        UserCodeClassWrapper original = new UserCodeClassWrapper(udf);
        UserCodeObjectWrapper wrapped = new UserCodeObjectWrapper((Object)new WrappingClassReduceFunction(udf));
        return new Builder((UserCodeWrapper)original, (UserCodeWrapper)wrapped);
    }

    public static Builder builder(Class<? extends ReduceFunction> udf, Class<? extends Key<?>> keyClass, int keyColumn) {
        UserCodeClassWrapper original = new UserCodeClassWrapper(udf);
        UserCodeObjectWrapper wrapped = new UserCodeObjectWrapper((Object)new WrappingClassReduceFunction(udf));
        return new Builder((UserCodeWrapper)original, (UserCodeWrapper)wrapped, keyClass, keyColumn);
    }

    protected ReduceOperator(Builder builder) {
        super(builder.udfWrapper, OperatorInfoHelper.unary(), builder.getKeyColumnsArray(), builder.name);
        this.keyTypes = builder.getKeyClassesArray();
        this.originalFunction = builder.originalUdf;
        if (builder.inputs != null && !builder.inputs.isEmpty()) {
            this.setInput(Operator.createUnionCascade((List)builder.inputs));
        }
        this.setGroupOrder(builder.secondaryOrder);
        this.setBroadcastVariables(builder.broadcastInputs);
        this.setSemanticProperties(FunctionAnnotation.readSingleConstantAnnotations(this.originalFunction));
    }

    public Class<? extends Key<?>>[] getKeyClasses() {
        return this.keyTypes;
    }

    public boolean isCombinable() {
        return super.isCombinable() || this.originalFunction.getUserCodeAnnotation(Combinable.class) != null;
    }

    public static final class WrappingClassReduceFunction
    extends WrappingReduceFunction {
        private static final long serialVersionUID = 1L;

        public WrappingClassReduceFunction(Class<? extends ReduceFunction> reducer) {
            super((ReduceFunction)((Object)InstantiationUtil.instantiate(reducer)));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(((Object)((Object)((ReduceFunction)this.wrappedFunction))).getClass());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Class clazz = (Class)in.readObject();
            this.wrappedFunction = (ReduceFunction)((Object)InstantiationUtil.instantiate((Class)clazz));
        }
    }

    public static class WrappingReduceFunction
    extends WrappingFunction<ReduceFunction>
    implements GroupReduceFunction<Record, Record>,
    GroupCombineFunction<Record, Record> {
        private static final long serialVersionUID = 1L;

        public WrappingReduceFunction(ReduceFunction reducer) {
            super(reducer);
        }

        public final void reduce(Iterable<Record> records, Collector<Record> out) throws Exception {
            ((ReduceFunction)this.wrappedFunction).reduce(records.iterator(), out);
        }

        public final void combine(Iterable<Record> records, Collector<Record> out) throws Exception {
            ((ReduceFunction)this.wrappedFunction).combine(records.iterator(), out);
        }
    }

    public static class Builder {
        private final UserCodeWrapper<ReduceFunction> originalUdf;
        private final UserCodeWrapper<GroupReduceFunction<Record, Record>> udfWrapper;
        private final List<Class<? extends Key<?>>> keyClasses;
        private final List<Integer> keyColumns;
        private Ordering secondaryOrder = null;
        private List<Operator<Record>> inputs;
        private Map<String, Operator<Record>> broadcastInputs;
        private String name = "<Unnamed Reducer>";

        private Builder(UserCodeWrapper<ReduceFunction> originalUdf, UserCodeWrapper<GroupReduceFunction<Record, Record>> wrappedUdf) {
            this.originalUdf = originalUdf;
            this.udfWrapper = wrappedUdf;
            this.keyClasses = new ArrayList();
            this.keyColumns = new ArrayList<Integer>();
            this.inputs = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        private Builder(UserCodeWrapper<ReduceFunction> originalUdf, UserCodeWrapper<GroupReduceFunction<Record, Record>> wrappedUdf, Class<? extends Key<?>> keyClass, int keyColumn) {
            this.originalUdf = originalUdf;
            this.udfWrapper = wrappedUdf;
            this.keyClasses = new ArrayList();
            this.keyClasses.add(keyClass);
            this.keyColumns = new ArrayList<Integer>();
            this.keyColumns.add(keyColumn);
            this.inputs = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        private int[] getKeyColumnsArray() {
            int[] result = new int[this.keyColumns.size()];
            for (int i = 0; i < this.keyColumns.size(); ++i) {
                result[i] = this.keyColumns.get(i);
            }
            return result;
        }

        private Class<? extends Key<?>>[] getKeyClassesArray() {
            return this.keyClasses.toArray(new Class[this.keyClasses.size()]);
        }

        public Builder keyField(Class<? extends Key<?>> keyClass, int keyColumn) {
            this.keyClasses.add(keyClass);
            this.keyColumns.add(keyColumn);
            return this;
        }

        public Builder secondaryOrder(Ordering order) {
            this.secondaryOrder = order;
            return this;
        }

        public Builder input(Operator<Record> input) {
            Preconditions.checkNotNull(input, "The input must not be null");
            this.inputs.clear();
            this.inputs.add(input);
            return this;
        }

        public Builder input(Operator<Record> ... inputs) {
            this.inputs.clear();
            Collections.addAll(this.inputs, inputs);
            return this;
        }

        public Builder inputs(List<Operator<Record>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder setBroadcastVariable(String name, Operator<Record> input) {
            this.broadcastInputs.put(name, input);
            return this;
        }

        public Builder setBroadcastVariables(Map<String, Operator<Record>> inputs) {
            this.broadcastInputs.clear();
            this.broadcastInputs.putAll(inputs);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ReduceOperator build() {
            if (this.name == null) {
                this.name = this.udfWrapper.getUserCodeClass().getName();
            }
            return new ReduceOperator(this);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Combinable {
    }
}

