/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapPartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;

public class MapPartitionOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, MapPartitionOperator<IN, OUT>> {
    protected final MapPartitionFunction<IN, OUT> function;
    protected final String defaultName;

    public MapPartitionOperator(DataSet<IN> input, TypeInformation<OUT> resultType, MapPartitionFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.function = function;
        this.defaultName = defaultName;
    }

    protected MapPartitionFunction<IN, OUT> getFunction() {
        return this.function;
    }

    protected MapPartitionOperatorBase<IN, OUT, MapPartitionFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : "MapPartition at " + this.defaultName;
        MapPartitionOperatorBase po = new MapPartitionOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setParallelism(this.getParallelism());
        } else {
            po.setParallelism(input.getParallelism());
        }
        return po;
    }
}

