/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public final class JacksonMapperFactory {
    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        JacksonMapperFactory.registerModules(objectMapper);
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        JacksonMapperFactory.registerModules(objectMapper);
        return objectMapper;
    }

    private static void registerModules(ObjectMapper mapper) {
        mapper.registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module().configureAbsentsAsNulls(true)).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private JacksonMapperFactory() {
    }
}

