/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source;

import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.source.KafkaSourceOptions;

@Internal
public class KafkaPropertiesUtil {
    private KafkaPropertiesUtil() {
    }

    public static void copyProperties(@Nonnull Properties from, @Nonnull Properties to) {
        for (String key : from.stringPropertyNames()) {
            to.setProperty(key, from.getProperty(key));
        }
    }

    public static void setClientIdPrefix(Properties properties, String kafkaClusterId) {
        String userClientIdPrefix = properties.getProperty(KafkaSourceOptions.CLIENT_ID_PREFIX.key());
        properties.setProperty(KafkaSourceOptions.CLIENT_ID_PREFIX.key(), userClientIdPrefix + "-" + kafkaClusterId);
    }
}

