/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.split;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;

@Internal
public class DynamicKafkaSourceSplit
extends KafkaPartitionSplit {
    private final String kafkaClusterId;
    private final KafkaPartitionSplit kafkaPartitionSplit;

    public DynamicKafkaSourceSplit(String kafkaClusterId, KafkaPartitionSplit kafkaPartitionSplit) {
        super(kafkaPartitionSplit.getTopicPartition(), kafkaPartitionSplit.getStartingOffset(), kafkaPartitionSplit.getStoppingOffset().orElse(Long.MIN_VALUE));
        this.kafkaClusterId = kafkaClusterId;
        this.kafkaPartitionSplit = kafkaPartitionSplit;
    }

    @Override
    public String splitId() {
        return this.kafkaClusterId + "-" + this.kafkaPartitionSplit.splitId();
    }

    public String getKafkaClusterId() {
        return this.kafkaClusterId;
    }

    public KafkaPartitionSplit getKafkaPartitionSplit() {
        return this.kafkaPartitionSplit;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kafkaClusterId", (Object)this.kafkaClusterId).add("kafkaPartitionSplit", (Object)this.kafkaPartitionSplit).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicKafkaSourceSplit that = (DynamicKafkaSourceSplit)o;
        return Objects.equals(this.kafkaClusterId, that.kafkaClusterId) && Objects.equals(this.kafkaPartitionSplit, that.kafkaPartitionSplit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.kafkaClusterId, this.kafkaPartitionSplit);
    }
}

