/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSinkCommittableSerializer
implements SimpleVersionedSerializer<FileSinkCommittable> {
    private static final int MAGIC_NUMBER = 511073408;
    private final SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileSerializer;
    private final SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileSerializer;

    public FileSinkCommittableSerializer(SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileSerializer, SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileSerializer) {
        this.pendingFileSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(pendingFileSerializer);
        this.inProgressFileSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(inProgressFileSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(FileSinkCommittable committable) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(256);
        out.writeInt(511073408);
        this.serializeV1(committable, (DataOutputView)out);
        return out.getCopyOfBuffer();
    }

    public FileSinkCommittable deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        switch (version) {
            case 1: {
                FileSinkCommittableSerializer.validateMagicNumber((DataInputView)in);
                return this.deserializeV1((DataInputView)in);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private void serializeV1(FileSinkCommittable committable, DataOutputView dataOutputView) throws IOException {
        if (committable.hasPendingFile()) {
            dataOutputView.writeBoolean(true);
            SimpleVersionedSerialization.writeVersionAndSerialize(this.pendingFileSerializer, (Object)committable.getPendingFile(), (DataOutputView)dataOutputView);
        } else {
            dataOutputView.writeBoolean(false);
        }
        if (committable.hasInProgressFileToCleanup()) {
            dataOutputView.writeBoolean(true);
            SimpleVersionedSerialization.writeVersionAndSerialize(this.inProgressFileSerializer, (Object)committable.getInProgressFileToCleanup(), (DataOutputView)dataOutputView);
        } else {
            dataOutputView.writeBoolean(false);
        }
    }

    private FileSinkCommittable deserializeV1(DataInputView dataInputView) throws IOException {
        InProgressFileWriter.PendingFileRecoverable pendingFile = null;
        if (dataInputView.readBoolean()) {
            pendingFile = (InProgressFileWriter.PendingFileRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.pendingFileSerializer, (DataInputView)dataInputView);
        }
        InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup = null;
        if (dataInputView.readBoolean()) {
            inProgressFileToCleanup = (InProgressFileWriter.InProgressFileRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.inProgressFileSerializer, (DataInputView)dataInputView);
        }
        return new FileSinkCommittable(pendingFile, inProgressFileToCleanup);
    }

    private static void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 511073408) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }
}

