/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;

@Internal
public final class FileRecords<T>
implements RecordsWithSplitIds<RecordAndPosition<T>> {
    @Nullable
    private String splitId;
    @Nullable
    private BulkFormat.RecordIterator<T> recordsForSplitCurrent;
    @Nullable
    private final BulkFormat.RecordIterator<T> recordsForSplit;
    private final Set<String> finishedSplits;

    private FileRecords(@Nullable String splitId, @Nullable BulkFormat.RecordIterator<T> recordsForSplit, Set<String> finishedSplits) {
        this.splitId = splitId;
        this.recordsForSplit = recordsForSplit;
        this.finishedSplits = finishedSplits;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        this.recordsForSplitCurrent = nextSplit != null ? this.recordsForSplit : null;
        return nextSplit;
    }

    @Nullable
    public RecordAndPosition<T> nextRecordFromSplit() {
        BulkFormat.RecordIterator<T> recordsForSplit = this.recordsForSplitCurrent;
        if (recordsForSplit != null) {
            return recordsForSplit.next();
        }
        throw new IllegalStateException();
    }

    public void recycle() {
        if (this.recordsForSplit != null) {
            this.recordsForSplit.releaseBatch();
        }
    }

    public Set<String> finishedSplits() {
        return this.finishedSplits;
    }

    public static <T> FileRecords<T> forRecords(String splitId, BulkFormat.RecordIterator<T> recordsForSplit) {
        return new FileRecords<T>(splitId, recordsForSplit, Collections.emptySet());
    }

    public static <T> FileRecords<T> finishedSplit(String splitId) {
        return new FileRecords<T>(null, null, Collections.singleton(splitId));
    }
}

