/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitState;
import org.apache.flink.connector.file.src.impl.FileSourceRecordEmitter;
import org.apache.flink.connector.file.src.impl.FileSourceSplitReader;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;

@Internal
public final class FileSourceReader<T, SplitT extends FileSourceSplit>
extends SingleThreadMultiplexSourceReaderBase<RecordAndPosition<T>, T, SplitT, FileSourceSplitState<SplitT>> {
    public FileSourceReader(SourceReaderContext readerContext, BulkFormat<T, SplitT> readerFormat, Configuration config) {
        super(() -> new FileSourceSplitReader(config, readerFormat), new FileSourceRecordEmitter(), config, readerContext);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected void onSplitFinished(Map<String, FileSourceSplitState<SplitT>> finishedSplitIds) {
        this.context.sendSplitRequest();
    }

    protected FileSourceSplitState<SplitT> initializedState(SplitT split) {
        return new FileSourceSplitState<SplitT>(split);
    }

    protected SplitT toSplitType(String splitId, FileSourceSplitState<SplitT> splitState) {
        return splitState.toFileSourceSplit();
    }
}

