/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.compression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.compression.Bzip2InputStreamFactory;
import org.apache.flink.api.common.io.compression.DeflateInflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.GzipInflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.XZInputStreamFactory;

@PublicEvolving
public final class StandardDeCompressors {
    private static final Map<String, InflaterInputStreamFactory<?>> DECOMPRESSORS = StandardDeCompressors.buildDecompressorMap(new InflaterInputStreamFactory[]{DeflateInflaterInputStreamFactory.getInstance(), GzipInflaterInputStreamFactory.getInstance(), Bzip2InputStreamFactory.getInstance(), XZInputStreamFactory.getInstance()});
    private static final Collection<String> COMMON_SUFFIXES = Collections.unmodifiableList(new ArrayList<String>(DECOMPRESSORS.keySet()));

    public static Collection<String> getCommonSuffixes() {
        return COMMON_SUFFIXES;
    }

    @Nullable
    public static InflaterInputStreamFactory<?> getDecompressorForExtension(String extension) {
        return DECOMPRESSORS.get(extension);
    }

    @Nullable
    public static InflaterInputStreamFactory<?> getDecompressorForFileName(String fileName) {
        for (Map.Entry<String, InflaterInputStreamFactory<?>> entry : DECOMPRESSORS.entrySet()) {
            if (!fileName.endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Map<String, InflaterInputStreamFactory<?>> buildDecompressorMap(InflaterInputStreamFactory<?> ... decompressors) {
        LinkedHashMap map = new LinkedHashMap(decompressors.length);
        for (InflaterInputStreamFactory<?> decompressor : decompressors) {
            for (String suffix : decompressor.getCommonFileExtensions()) {
                map.put(suffix, decompressor);
            }
        }
        return map;
    }

    private StandardDeCompressors() {
    }
}

