/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultClusterClientServiceLoader
implements ClusterClientServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClusterClientServiceLoader.class);

    @Override
    public <ClusterID> ClusterClientFactory<ClusterID> getClusterClientFactory(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        ServiceLoader<ClusterClientFactory> loader = ServiceLoader.load(ClusterClientFactory.class);
        ArrayList<ClusterClientFactory> compatibleFactories = new ArrayList<ClusterClientFactory>();
        Iterator<ClusterClientFactory> factories = loader.iterator();
        while (factories.hasNext()) {
            try {
                ClusterClientFactory factory = factories.next();
                if (factory == null || !factory.isCompatibleWith(configuration)) continue;
                compatibleFactories.add(factory);
            }
            catch (Throwable e2) {
                if (e2.getCause() instanceof NoClassDefFoundError) {
                    LOG.info("Could not load factory due to missing dependencies.");
                    continue;
                }
                throw e2;
            }
        }
        if (compatibleFactories.size() > 1) {
            List configStr = configuration.toMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
            throw new IllegalStateException("Multiple compatible client factories found for:\n" + String.join((CharSequence)"\n", configStr) + ".");
        }
        if (compatibleFactories.isEmpty()) {
            throw new IllegalStateException("No ClusterClientFactory found. If you were targeting a Yarn cluster, please make sure to export the HADOOP_CLASSPATH environment variable or have hadoop in your classpath. For more information refer to the \"Deployment\" section of the official Apache Flink documentation.");
        }
        return (ClusterClientFactory)compatibleFactories.get(0);
    }

    @Override
    public Stream<String> getApplicationModeTargetNames() {
        ServiceLoader<ClusterClientFactory> loader = ServiceLoader.load(ClusterClientFactory.class);
        ArrayList<String> result = new ArrayList<String>();
        Iterator<ClusterClientFactory> it = loader.iterator();
        while (it.hasNext()) {
            try {
                ClusterClientFactory clientFactory = it.next();
                Optional<String> applicationName = clientFactory.getApplicationTargetName();
                if (!applicationName.isPresent()) continue;
                result.add(applicationName.get());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return result.stream();
    }
}

