/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.reflect.Nullable;
import org.apache.flink.annotation.Internal;

@Internal
final class SerializableAvroSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient Schema schema;

    SerializableAvroSchema() {
    }

    SerializableAvroSchema(Schema schema) {
        this.schema = schema;
    }

    Schema getAvroSchema() {
        return this.schema;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.schema == null) {
            oos.writeBoolean(false);
        } else {
            oos.writeBoolean(true);
            oos.writeUTF(this.schema.toString(false));
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        if (ois.readBoolean()) {
            String schema = ois.readUTF();
            this.schema = new Schema.Parser().parse(schema);
        } else {
            this.schema = null;
        }
    }
}

