/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;

public class NestedDataColumnSupplier
implements Supplier<ComplexColumn> {
    private final NestedDataColumnMetadata metadata;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final GenericIndexed<String> fields;
    private final NestedLiteralTypeInfo fieldInfo;
    private final GenericIndexed<String> dictionary;
    private final FixedIndexed<Long> longDictionary;
    private final FixedIndexed<Double> doubleDictionary;
    private final ColumnConfig columnConfig;
    private final SmooshedFileMapper fileMapper;

    public NestedDataColumnSupplier(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper) {
        byte version = bb.get();
        if (version == 3) {
            try {
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                this.metadata = (NestedDataColumnMetadata)jsonMapper.readValue(IndexMerger.SERIALIZER_UTILS.readString(bb), NestedDataColumnMetadata.class);
                this.fields = GenericIndexed.read(bb, GenericIndexed.STRING_STRATEGY, mapper);
                this.fieldInfo = NestedLiteralTypeInfo.read(bb, this.fields.size());
                ByteBuffer stringDictionaryBuffer = this.loadInternalFile(mapper, "__stringDictionary");
                this.dictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.STRING_STRATEGY, mapper);
                ByteBuffer longDictionaryBuffer = this.loadInternalFile(mapper, "__longDictionary");
                this.longDictionary = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), this.metadata.getByteOrder(), 8);
                ByteBuffer doubleDictionaryBuffer = this.loadInternalFile(mapper, "__doubleDictionary");
                this.doubleDictionary = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), this.metadata.getByteOrder(), 8);
                ByteBuffer rawBuffer = this.loadInternalFile(mapper, "__raw").asReadOnlyBuffer();
                this.compressedRawColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(NestedDataColumnSerializer.getInternalFileName(this.metadata.getFileNameBase(), "__raw"), rawBuffer, this.metadata.getByteOrder(), mapper);
                if (this.metadata.hasNulls().booleanValue()) {
                    ByteBuffer nullIndexBuffer = this.loadInternalFile(mapper, "__nullIndex");
                    this.nullValues = this.metadata.getBitmapSerdeFactory().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                }
                this.nullValues = this.metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap();
            }
            catch (IOException ex) {
                throw new RE((Throwable)ex, "Failed to deserialize V3 column.", new Object[0]);
            }
        } else {
            throw new RE("Unknown version" + version, new Object[0]);
        }
        this.fileMapper = (SmooshedFileMapper)Preconditions.checkNotNull((Object)columnBuilder.getFileMapper(), (Object)"Null fileMapper");
        this.columnConfig = columnConfig;
    }

    public ComplexColumn get() {
        return new CompressedNestedDataComplexColumn(this.metadata, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.dictionary, this.longDictionary, this.doubleDictionary, this.fileMapper);
    }

    private ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, String internalFileName) throws IOException {
        return fileMapper.mapFile(NestedDataColumnSerializer.getInternalFileName(this.metadata.getFileNameBase(), internalFileName));
    }
}

