/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Map;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;

public class MapIndex
implements IndexedTable.Index {
    private final ColumnType keyType;
    private final Map<Object, IntList> index;
    private final boolean keysUnique;
    private final boolean isLong2ObjectMap;

    MapIndex(ColumnType keyType, Map<Object, IntList> index, boolean keysUnique) {
        this.keyType = (ColumnType)Preconditions.checkNotNull((Object)keyType, (Object)"keyType");
        this.index = (Map)Preconditions.checkNotNull(index, (Object)"index");
        this.keysUnique = keysUnique;
        this.isLong2ObjectMap = index instanceof Long2ObjectMap;
    }

    @Override
    public ColumnType keyType() {
        return this.keyType;
    }

    @Override
    public boolean areKeysUnique() {
        return this.keysUnique;
    }

    @Override
    public IntList find(Object key) {
        Comparable<?> convertedKey = DimensionHandlerUtils.convertObjectToType(key, (TypeSignature<ValueType>)this.keyType, false);
        if (convertedKey != null) {
            IntList found = this.index.get(convertedKey);
            if (found != null) {
                return found;
            }
            return IntLists.EMPTY_LIST;
        }
        return IntLists.EMPTY_LIST;
    }

    @Override
    public int findUniqueLong(long key) {
        if (this.isLong2ObjectMap && this.keysUnique) {
            IntList rows = (IntList)((Long2ObjectMap)this.index).get(key);
            assert (rows == null || rows.size() == 1);
            return rows != null ? rows.getInt(0) : -1;
        }
        throw new UnsupportedOperationException();
    }
}

