/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.util.SuppressForbidden;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;
import org.apache.druid.segment.join.table.SortedIntIntersectionIterator;

public class IndexedTableJoinMatcher
implements JoinMatcher {
    static final int NO_CONDITION_MATCH = -1;
    private static final int UNINITIALIZED_CURRENT_ROW = -1;
    static final ColumnType DEFAULT_KEY_TYPE = ColumnType.STRING;
    private final IndexedTable table;
    private final List<ConditionMatcher> conditionMatchers;
    private final boolean singleRowMatching;
    private final IntIterator[] currentMatchedRows;
    private final ColumnSelectorFactory selectorFactory;
    private final IntSet matchedRows;
    private boolean matchingRemainder = false;
    @Nullable
    private IntIterator currentIterator;
    private int currentRow;
    private final SimpleSettableOffset joinableOffset;

    IndexedTableJoinMatcher(IndexedTable table, ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, boolean descending, Closer closer) {
        this.table = table;
        this.joinableOffset = descending ? new SimpleDescendingOffset(table.numRows()) : new SimpleAscendingOffset(table.numRows());
        this.reset();
        if (condition.isAlwaysTrue()) {
            this.conditionMatchers = Collections.singletonList(() -> IntIterators.fromTo((int)0, (int)table.numRows()));
            this.singleRowMatching = false;
        } else if (condition.isAlwaysFalse()) {
            this.conditionMatchers = Collections.singletonList(() -> IntIterators.EMPTY_ITERATOR);
            this.singleRowMatching = false;
        } else if (condition.getNonEquiConditions().isEmpty()) {
            List indexes = condition.getEquiConditions().stream().map(eq -> Pair.of((Object)IndexedTableJoinMatcher.getIndex(table, eq), (Object)eq)).collect(Collectors.toCollection(ArrayList::new));
            this.conditionMatchers = indexes.stream().map(pair -> IndexedTableJoinMatcher.makeConditionMatcher((IndexedTable.Index)pair.lhs, leftSelectorFactory, (Equality)pair.rhs)).collect(Collectors.toList());
            this.singleRowMatching = indexes.stream().allMatch(pair -> ((IndexedTable.Index)pair.lhs).areKeysUnique());
        } else {
            throw new IAE("Cannot build hash-join matcher on non-equi-join condition: %s", new Object[]{condition.getOriginalExpression()});
        }
        this.currentMatchedRows = !this.singleRowMatching ? new IntIterator[this.conditionMatchers.size()] : null;
        ColumnSelectorFactory selectorFactory = table.makeColumnSelectorFactory(this.joinableOffset, descending, closer);
        this.selectorFactory = selectorFactory != null ? selectorFactory : new IndexedTableColumnSelectorFactory(table, () -> this.currentRow, closer);
        this.matchedRows = remainderNeeded ? new IntRBTreeSet() : null;
    }

    private static IndexedTable.Index getIndex(IndexedTable table, Equality condition) {
        if (!table.keyColumns().contains(condition.getRightColumn())) {
            throw new IAE("Cannot build hash-join matcher on non-key-based condition: %s", new Object[]{condition});
        }
        int keyColumnNumber = table.rowSignature().indexOf(condition.getRightColumn());
        return table.columnIndex(keyColumnNumber);
    }

    private static ConditionMatcher makeConditionMatcher(IndexedTable.Index index, ColumnSelectorFactory selectorFactory, Equality condition) {
        return ColumnProcessors.makeProcessor(condition.getLeftExpr(), index.keyType(), new ConditionMatcherFactory(index), selectorFactory);
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public void matchCondition() {
        this.reset();
        if (this.singleRowMatching) {
            if (this.conditionMatchers.size() == 1) {
                this.currentRow = this.conditionMatchers.get(0).matchSingleRow();
            } else {
                this.currentRow = this.conditionMatchers.get(0).matchSingleRow();
                for (int i = 1; i < this.conditionMatchers.size(); ++i) {
                    if (this.currentRow == this.conditionMatchers.get(i).matchSingleRow()) continue;
                    this.currentRow = -1;
                    break;
                }
            }
        } else {
            if (this.conditionMatchers.size() == 1) {
                this.currentIterator = this.conditionMatchers.get(0).match();
            } else {
                for (int i = 0; i < this.conditionMatchers.size(); ++i) {
                    IntIterator rows = this.conditionMatchers.get(i).match();
                    if (!rows.hasNext()) {
                        return;
                    }
                    this.currentMatchedRows[i] = rows;
                }
                this.currentIterator = new SortedIntIntersectionIterator(this.currentMatchedRows);
            }
            this.advanceCurrentRow();
        }
        this.addCurrentRowToMatchedRows();
    }

    @Override
    public void matchRemainder() {
        Preconditions.checkState((this.matchedRows != null ? 1 : 0) != 0, (Object)"matchedRows != null");
        this.currentIterator = new IntIterator(){
            int current = -1;
            {
                this.advanceRemainderIterator();
            }

            public int nextInt() {
                if (this.current >= IndexedTableJoinMatcher.this.table.numRows()) {
                    throw new NoSuchElementException();
                }
                int retVal = this.current;
                this.advanceRemainderIterator();
                return retVal;
            }

            public boolean hasNext() {
                return this.current < IndexedTableJoinMatcher.this.table.numRows();
            }

            private void advanceRemainderIterator() {
                do {
                    ++this.current;
                } while (this.current < IndexedTableJoinMatcher.this.table.numRows() && IndexedTableJoinMatcher.this.matchedRows.contains(this.current));
            }
        };
        this.matchingRemainder = true;
        this.advanceCurrentRow();
    }

    @Override
    public boolean matchingRemainder() {
        return this.matchingRemainder;
    }

    @Override
    public boolean hasMatch() {
        return this.currentRow >= 0;
    }

    @Override
    public void nextMatch() {
        this.advanceCurrentRow();
        this.addCurrentRowToMatchedRows();
    }

    @Override
    public void reset() {
        this.currentIterator = null;
        this.currentRow = -1;
        this.matchingRemainder = false;
        this.joinableOffset.reset();
    }

    private void advanceCurrentRow() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.currentRow = this.currentIterator.nextInt();
        } else {
            this.currentIterator = null;
            this.currentRow = -1;
            this.joinableOffset.setCurrentOffset(this.currentRow);
        }
    }

    private void addCurrentRowToMatchedRows() {
        if (!this.matchingRemainder && this.matchedRows != null && this.hasMatch()) {
            this.matchedRows.add(this.currentRow);
        }
    }

    @VisibleForTesting
    static class Int2IntListLruCache
    implements Int2IntListMap {
        private final Int2ObjectLinkedOpenHashMap<IntList> cache;
        private final int maxSize;
        private final IntFunction<IntList> loader;

        Int2IntListLruCache(int maxSize, IntFunction<IntList> loader) {
            this.cache = new Int2ObjectLinkedOpenHashMap(maxSize);
            this.maxSize = maxSize;
            this.loader = loader;
        }

        @Override
        public IntList getAndLoadIfAbsent(int key) {
            IntList value = (IntList)this.cache.getAndMoveToFirst(key);
            if (value == null) {
                value = this.loader.apply(key);
                this.cache.putAndMoveToFirst(key, (Object)value);
            }
            if (this.cache.size() > this.maxSize) {
                this.cache.removeLast();
            }
            return value;
        }

        @VisibleForTesting
        IntList get(int key) {
            return (IntList)this.cache.get(key);
        }
    }

    @VisibleForTesting
    static class Int2IntListLookupTable
    implements Int2IntListMap {
        private final IntList[] lookup;
        private final IntFunction<IntList> loader;

        Int2IntListLookupTable(int maxSize, IntFunction<IntList> loader) {
            this.loader = loader;
            this.lookup = new IntList[maxSize];
        }

        @Override
        public IntList getAndLoadIfAbsent(int key) {
            IntList value = this.lookup[key];
            if (value == null) {
                this.lookup[key] = value = this.loader.apply(key);
            }
            return value;
        }
    }

    private static interface Int2IntListMap {
        public IntList getAndLoadIfAbsent(int var1);
    }

    @VisibleForTesting
    static class LruLoadingHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;
        private final Function<K, V> loader;

        @SuppressForbidden(reason="java.util.LinkedHashMap#<init>(int)")
        LruLoadingHashMap(int maxSize, Function<K, V> loader) {
            super(LruLoadingHashMap.capacity(maxSize));
            this.maxSize = maxSize;
            this.loader = loader;
        }

        V getAndLoadIfAbsent(K key) {
            return this.computeIfAbsent(key, this.loader);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }

        private static int capacity(int expectedSize) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
    }

    @VisibleForTesting
    static class ConditionMatcherFactory
    implements ColumnProcessorFactory<ConditionMatcher> {
        @VisibleForTesting
        static final int CACHE_MAX_SIZE = 1000;
        private static final int MAX_NUM_CACHE = 10;
        private final ColumnType keyType;
        private final IndexedTable.Index index;
        private final LruLoadingHashMap<DimensionSelector, Int2IntListMap> dimensionCaches;

        ConditionMatcherFactory(IndexedTable.Index index) {
            this.keyType = index.keyType();
            this.index = index;
            this.dimensionCaches = new LruLoadingHashMap<DimensionSelector, Int2IntListMap>(10, selector -> {
                int cardinality = selector.getValueCardinality();
                IntFunction<IntList> loader = dimensionId -> this.getRowNumbers((DimensionSelector)selector, dimensionId);
                return cardinality <= 1000 ? new Int2IntListLookupTable(cardinality, loader) : new Int2IntListLruCache(1000, loader);
            });
        }

        private IntList getRowNumbers(DimensionSelector selector, int dimensionId) {
            String key = selector.lookupName(dimensionId);
            return this.index.find(key);
        }

        private IntList getAndCacheRowNumbers(DimensionSelector selector, int dimensionId) {
            return this.dimensionCaches.getAndLoadIfAbsent(selector).getAndLoadIfAbsent(dimensionId);
        }

        @Override
        public ColumnType defaultType() {
            return this.keyType;
        }

        @Override
        public ConditionMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            if (selector.getValueCardinality() == -1) {
                return () -> {
                    IndexedInts row = selector.getRow();
                    if (row.size() == 1) {
                        int dimensionId = row.get(0);
                        IntList rowNumbers = this.getRowNumbers(selector, dimensionId);
                        return rowNumbers.iterator();
                    }
                    if (row.size() == 0) {
                        return IntIterators.EMPTY_ITERATOR;
                    }
                    throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
                };
            }
            return () -> {
                IndexedInts row = selector.getRow();
                if (row.size() == 1) {
                    int dimensionId = row.get(0);
                    IntList rowNumbers = this.getAndCacheRowNumbers(selector, dimensionId);
                    return rowNumbers.iterator();
                }
                if (row.size() == 0) {
                    return IntIterators.EMPTY_ITERATOR;
                }
                throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
            };
        }

        @Override
        public ConditionMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(Float.valueOf(selector.getFloat())).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(Float.valueOf(selector.getFloat())).iterator();
        }

        @Override
        public ConditionMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(selector.getDouble()).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(selector.getDouble()).iterator();
        }

        @Override
        public ConditionMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
            if (this.index.keyType().is((TypeDescriptor)ValueType.LONG)) {
                return this.makePrimitiveLongMatcher(selector);
            }
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(selector.getLong()).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(selector.getLong()).iterator();
        }

        @Override
        public ConditionMatcher makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return new ConditionMatcher(){

                @Override
                public int matchSingleRow() {
                    return -1;
                }

                @Override
                public IntIterator match() {
                    return IntIterators.EMPTY_ITERATOR;
                }
            };
        }

        private ConditionMatcher makePrimitiveLongMatcher(final BaseLongColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return new ConditionMatcher(){

                    @Override
                    public int matchSingleRow() {
                        return index.findUniqueLong(selector.getLong());
                    }

                    @Override
                    public IntIterator match() {
                        return index.find(selector.getLong()).iterator();
                    }
                };
            }
            return new ConditionMatcher(){

                @Override
                public int matchSingleRow() {
                    return selector.isNull() ? -1 : index.findUniqueLong(selector.getLong());
                }

                @Override
                public IntIterator match() {
                    return selector.isNull() ? IntIterators.EMPTY_ITERATOR : index.find(selector.getLong()).iterator();
                }
            };
        }
    }

    static interface ConditionMatcher {
        default public int matchSingleRow() {
            IntIterator it = this.match();
            return it.hasNext() ? it.nextInt() : -1;
        }

        public IntIterator match();
    }
}

