/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class CompressedBlockSerializer
implements Serializer {
    private static final MetaSerdeHelper<CompressedBlockSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 1).writeByte(x -> x.compression.getId()).writeInt(x -> 65536).writeInt(x -> x.numBlocks);
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final CompressionStrategy compression;
    private final CompressionStrategy.Compressor compressor;
    private final ByteBuffer offsetValueConverter = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
    @Nullable
    private ByteBuffer uncompressedDataBuffer;
    private ByteBuffer compressedDataBuffer;
    private int numBlocks;
    private int currentOffset;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valuesOut = null;

    public CompressedBlockSerializer(SegmentWriteOutMedium segmentWriteOutMedium, CompressionStrategy compression, int blockSize) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.compression = compression;
        this.compressor = compression.getCompressor();
        this.uncompressedDataBuffer = this.compressor.allocateInBuffer(blockSize, segmentWriteOutMedium.getCloser()).order(ByteOrder.nativeOrder());
        this.compressedDataBuffer = this.compressor.allocateOutBuffer(blockSize, segmentWriteOutMedium.getCloser()).order(ByteOrder.nativeOrder());
    }

    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    public void addValue(byte[] bytes) throws IOException {
        if (this.uncompressedDataBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        this.flushIfNeeded();
        if (bytes.length <= this.uncompressedDataBuffer.remaining()) {
            this.uncompressedDataBuffer.put(bytes);
        } else {
            int next;
            for (int written = 0; written < bytes.length; written += next) {
                next = Math.min(this.uncompressedDataBuffer.remaining(), bytes.length - written);
                this.uncompressedDataBuffer.put(bytes, written, next);
                this.flushIfNeeded();
            }
        }
    }

    public void addValue(ByteBuffer bytes) throws IOException {
        if (this.uncompressedDataBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        this.flushIfNeeded();
        int size = bytes.remaining();
        if (size <= this.uncompressedDataBuffer.remaining()) {
            this.uncompressedDataBuffer.put(bytes);
        } else {
            ByteBuffer transferBuffer = bytes.asReadOnlyBuffer().order(bytes.order());
            while (transferBuffer.hasRemaining()) {
                int writeSize = Math.min(transferBuffer.remaining(), this.uncompressedDataBuffer.remaining());
                transferBuffer.limit(transferBuffer.position() + writeSize);
                this.uncompressedDataBuffer.put(transferBuffer);
                transferBuffer.limit(bytes.limit());
                this.flushIfNeeded();
            }
        }
        bytes.rewind();
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)META_SERDE_HELPER.size(this) + this.headerOut.size() + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        META_SERDE_HELPER.writeTo(channel, this);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    private void flushIfNeeded() throws IOException {
        if (!this.uncompressedDataBuffer.hasRemaining()) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.uncompressedDataBuffer.rewind();
        this.compressedDataBuffer.clear();
        ByteBuffer compressed = this.compressor.compress(this.uncompressedDataBuffer, this.compressedDataBuffer);
        this.currentOffset += compressed.remaining();
        this.offsetValueConverter.clear();
        this.offsetValueConverter.putInt(this.currentOffset);
        this.offsetValueConverter.flip();
        Channels.writeFully((WritableByteChannel)this.headerOut, (ByteBuffer)this.offsetValueConverter);
        Channels.writeFully((WritableByteChannel)this.valuesOut, (ByteBuffer)compressed);
        this.uncompressedDataBuffer.clear();
        ++this.numBlocks;
        if (this.numBlocks < 0) {
            throw new ColumnCapacityExceededException("compressed");
        }
    }

    private void writeEndBuffer() throws IOException {
        if (this.uncompressedDataBuffer != null) {
            this.uncompressedDataBuffer.flip();
            this.flushBuffer();
            this.uncompressedDataBuffer = null;
        }
    }
}

