/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarFloatsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class BlockLayoutColumnarFloatsSerializer
implements ColumnarFloatsSerializer {
    private static final MetaSerdeHelper<BlockLayoutColumnarFloatsSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 16384).writeByte(x -> x.compression.getId());
    private final String columnName;
    private final GenericIndexedWriter<ByteBuffer> flattener;
    private final CompressionStrategy compression;
    private int numInserted = 0;
    @Nullable
    private ByteBuffer endBuffer;

    BlockLayoutColumnarFloatsSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        this.columnName = columnName;
        this.flattener = GenericIndexedWriter.ofCompressedByteBuffers(segmentWriteOutMedium, filenameBase, compression, 65536);
        this.compression = compression;
        CompressionStrategy.Compressor compressor = compression.getCompressor();
        Closer closer = segmentWriteOutMedium.getCloser();
        this.endBuffer = compressor.allocateInBuffer(65536, closer).order(byteOrder);
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(float value) throws IOException {
        if (this.endBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(this.endBuffer);
            this.endBuffer.clear();
        }
        this.endBuffer.putFloat(value);
        ++this.numInserted;
        if (this.numInserted < 0) {
            throw new ColumnCapacityExceededException(this.columnName);
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)META_SERDE_HELPER.size(this) + this.flattener.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        META_SERDE_HELPER.writeTo(channel, this);
        this.flattener.writeTo(channel, smoosher);
    }

    private void writeEndBuffer() throws IOException {
        if (this.endBuffer != null) {
            this.endBuffer.flip();
            if (this.endBuffer.remaining() > 0) {
                this.flattener.write(this.endBuffer);
            }
            this.endBuffer = null;
        }
    }
}

