/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class NilColumnValueSelector
implements ColumnValueSelector {
    private static final NilColumnValueSelector INSTANCE = NullHandling.sqlCompatible() ? new SqlCompatibleNilColumnValueSelector() : new NilColumnValueSelector();

    public static NilColumnValueSelector instance() {
        return INSTANCE;
    }

    private NilColumnValueSelector() {
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    @Nullable
    public Object getObject() {
        return null;
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    private static class SqlCompatibleNilColumnValueSelector
    extends NilColumnValueSelector {
        private SqlCompatibleNilColumnValueSelector() {
        }

        @Override
        public double getDouble() {
            throw new IllegalStateException("Cannot return null value as double");
        }

        @Override
        public float getFloat() {
            throw new IllegalStateException("Cannot return null value as float");
        }

        @Override
        public long getLong() {
            throw new IllegalStateException("Cannot return null value as long");
        }
    }
}

