/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.ForwardingRowIterator;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;

@ImplementedBy(value=IndexMergerV9.class)
public interface IndexMerger {
    public static final Logger log = new Logger(IndexMerger.class);
    public static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    public static final int INVALID_ROW = -1;
    public static final int UNLIMITED_MAX_COLUMNS_TO_MERGE = -1;

    public static List<String> getMergedDimensionsFromQueryableIndexes(List<QueryableIndex> indexes, @Nullable DimensionsSpec dimensionsSpec) {
        return IndexMerger.getMergedDimensions(IndexMerger.toIndexableAdapters(indexes), dimensionsSpec);
    }

    public static List<IndexableAdapter> toIndexableAdapters(List<QueryableIndex> indexes) {
        return indexes.stream().map(QueryableIndexIndexableAdapter::new).collect(Collectors.toList());
    }

    public static List<String> getMergedDimensions(List<IndexableAdapter> indexes, @Nullable DimensionsSpec dimensionsSpec) {
        if (indexes.size() == 0) {
            return ImmutableList.of();
        }
        List<String> commonDimOrder = IndexMerger.getLongestSharedDimOrder(indexes, dimensionsSpec);
        if (commonDimOrder == null) {
            log.warn("Indexes have incompatible dimension orders and there is no valid dimension ordering in the ingestionSpec, using lexicographic order.", new Object[0]);
            return IndexMerger.getLexicographicMergedDimensions(indexes);
        }
        return commonDimOrder;
    }

    @Nullable
    public static List<String> getLongestSharedDimOrder(List<IndexableAdapter> indexes, @Nullable DimensionsSpec dimensionsSpec) {
        int maxSize = 0;
        List<String> orderingCandidate = null;
        for (IndexableAdapter index : indexes) {
            int iterSize = index.getDimensionNames().size();
            if (iterSize <= maxSize) continue;
            maxSize = iterSize;
            orderingCandidate = index.getDimensionNames();
        }
        if (orderingCandidate == null) {
            return null;
        }
        if (IndexMerger.isDimensionOrderingValid(indexes, orderingCandidate)) {
            return ImmutableList.copyOf(orderingCandidate);
        }
        log.info("Indexes have incompatible dimension orders, try falling back on dimension ordering from ingestionSpec", new Object[0]);
        if (dimensionsSpec == null || CollectionUtils.isNullOrEmpty((Collection)dimensionsSpec.getDimensionNames())) {
            log.info("Cannot fall back on dimension ordering from ingestionSpec as it does not exist", new Object[0]);
            return null;
        }
        ArrayList<String> candidate = new ArrayList<String>(dimensionsSpec.getDimensionNames());
        Set allValidDimensions = indexes.stream().flatMap(indexableAdapter -> indexableAdapter.getDimensionNames().stream()).collect(Collectors.toSet());
        candidate.retainAll(allValidDimensions);
        if (candidate.size() != allValidDimensions.size()) {
            log.error("Dimension mismatched between ingestionSpec and indexes. ingestionSpec[%s] indexes[%s]", new Object[]{candidate, allValidDimensions});
            return null;
        }
        if (!IndexMerger.isDimensionOrderingValid(indexes, candidate)) {
            log.error("Dimension from ingestionSpec has invalid ordering", new Object[0]);
            return null;
        }
        log.info("Dimension ordering from ingestionSpec is valid. Fall back on dimension ordering [%s]", new Object[]{candidate});
        return candidate;
    }

    public static boolean isDimensionOrderingValid(List<IndexableAdapter> indexes, Iterable<String> orderingCandidate) {
        for (IndexableAdapter index : indexes) {
            Iterator<String> candidateIter = orderingCandidate.iterator();
            for (String matchDim : index.getDimensionNames()) {
                boolean matched = false;
                while (candidateIter.hasNext()) {
                    String nextDim = candidateIter.next();
                    if (!matchDim.equals(nextDim)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> getLexicographicMergedDimensions(List<IndexableAdapter> indexes) {
        return IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
    }

    public static <T extends Comparable<? super T>> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet<Comparable> retVal = new TreeSet<Comparable>((Comparator<Comparable>)Comparators.naturalNullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList(retVal);
    }

    @VisibleForTesting
    default public File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, index.getInterval(), outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    default public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    public File persist(IncrementalIndex var1, Interval var2, File var3, IndexSpec var4, ProgressIndicator var5, @Nullable SegmentWriteOutMediumFactory var6) throws IOException;

    @VisibleForTesting
    default public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
        return this.mergeQueryableIndex(indexes, rollup, metricAggs, null, outDir, indexSpec, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory, maxColumnsToMerge);
    }

    public File mergeQueryableIndex(List<QueryableIndex> var1, boolean var2, AggregatorFactory[] var3, @Nullable DimensionsSpec var4, File var5, IndexSpec var6, IndexSpec var7, ProgressIndicator var8, @Nullable SegmentWriteOutMediumFactory var9, int var10) throws IOException;

    @VisibleForTesting
    public File merge(List<IndexableAdapter> var1, boolean var2, AggregatorFactory[] var3, File var4, DimensionsSpec var5, IndexSpec var6, int var7) throws IOException;

    public static TransformableRowIterator toMergedIndexRowIterator(TransformableRowIterator sourceRowIterator, int indexNumber, List<DimensionMergerV9> mergers) {
        RowPointer sourceRowPointer = sourceRowIterator.getPointer();
        TimeAndDimsPointer markedSourceRowPointer = sourceRowIterator.getMarkedPointer();
        boolean anySelectorChanged = false;
        ColumnValueSelector[] convertedDimensionSelectors = new ColumnValueSelector[mergers.size()];
        ColumnValueSelector[] convertedMarkedDimensionSelectors = new ColumnValueSelector[mergers.size()];
        for (int i = 0; i < mergers.size(); ++i) {
            ColumnValueSelector convertedDimensionSelector;
            ColumnValueSelector sourceDimensionSelector = sourceRowPointer.getDimensionSelector(i);
            convertedDimensionSelectors[i] = convertedDimensionSelector = mergers.get(i).convertSortedSegmentRowValuesToMergedRowValues(indexNumber, sourceDimensionSelector);
            anySelectorChanged |= convertedDimensionSelector != sourceDimensionSelector;
            convertedMarkedDimensionSelectors[i] = mergers.get(i).convertSortedSegmentRowValuesToMergedRowValues(indexNumber, markedSourceRowPointer.getDimensionSelector(i));
        }
        if (!anySelectorChanged) {
            return sourceRowIterator;
        }
        return IndexMerger.makeRowIteratorWithConvertedDimensionColumns(sourceRowIterator, convertedDimensionSelectors, convertedMarkedDimensionSelectors);
    }

    public static TransformableRowIterator makeRowIteratorWithConvertedDimensionColumns(TransformableRowIterator sourceRowIterator, ColumnValueSelector[] convertedDimensionSelectors, ColumnValueSelector[] convertedMarkedDimensionSelectors) {
        final RowPointer convertedRowPointer = sourceRowIterator.getPointer().withDimensionSelectors(convertedDimensionSelectors);
        final TimeAndDimsPointer convertedMarkedRowPointer = sourceRowIterator.getMarkedPointer().withDimensionSelectors(convertedMarkedDimensionSelectors);
        return new ForwardingRowIterator(sourceRowIterator){

            @Override
            public RowPointer getPointer() {
                return convertedRowPointer;
            }

            @Override
            public TimeAndDimsPointer getMarkedPointer() {
                return convertedMarkedRowPointer;
            }
        };
    }
}

